<?php

use Infixs\CorreiosAutomatico\Utils\Formatter;
/**
 * Tracking History Component
 * 
 * @package Infixs\CorreiosAutomatico
 * @since   1.2.2
 * 
 * @global array $objects
 * @global \WC_Order $order
 * @global bool $search
 */

defined( 'ABSPATH' ) || exit;
?>
<div class="infixs-caref-order-tracking-history">
	<?php if ( count( $objects ) > 1 ) : ?>
		<div class="infixs-caref-order-tracking-tabs">
			<?php foreach ( $objects as $object ) : ?>
				<div class="infixs-caref-order-tracking-tab<?php echo esc_attr( $object === reset( $objects ) ? ' active' : '' ); ?>"
					data-id="<?php echo esc_attr( $object['id'] ); ?>">
					<?php echo esc_html( $object['code'] ); ?>
				</div>
			<?php endforeach; ?>
		</div>
	<?php endif; ?>
	<?php if ( count( $objects ) > 0 ) : ?>
		<?php foreach ( $objects as $object ) :
			$show_more = count( $object['events'] ) > 4;
			?>
			<div class="infixs-caref-order-tracking-box" data-tab="<?php echo esc_attr( $object['id'] ); ?>"
				style="<?php echo $object !== reset( $objects ) ? 'display: none;' : ''; ?>">
				<div class="infixs-caref-order-tracking-info">
					<?php if ( $object['expected_date'] ) : ?>
						<div>Previsão de Entrega:
							<strong><?php echo esc_html( Formatter::format_timestamp( strtotime( $object['expected_date'] ), 'd/m/Y' ) ); ?></strong>
						</div>
					<?php endif; ?>
					<div>Código de Rastreio: <strong><?php echo esc_html( $object['code'] ); ?></strong></div>
					<?php if ( $object['category'] ) : ?>
						<div>Tipo: <strong><?php echo esc_html( $object['category'] ); ?></strong></div>
					<?php endif; ?>
				</div>
				<div class="infixs-caref-order-tracking-event-list-wrapper">
					<div class="infixs-caref-order-tracking-event-list"
						style="<?php echo $show_more ? 'height: 400px;' : ''; ?>">
						<?php foreach ( $object['events'] as $event ) : ?>
							<div class="infixs-caref-order-tracking-row">
								<div>
									<div class="infixs-caref-order-tracking-icon">
										<?php if ( $event['code'] === 'BDI' && $event['type'] == '01' ) : ?>
											<svg xmlns="http://www.w3.org/2000/svg" width="256" height="256" viewBox="0 0 256 256">
												<path fill="#2271b1"
													d="M170.83 101.17a4 4 0 0 1 0 5.66l-56 56a4 4 0 0 1-5.66 0l-24-24a4 4 0 0 1 5.66-5.66L112 154.34l53.17-53.17a4 4 0 0 1 5.66 0M228 128A100 100 0 1 1 128 28a100.11 100.11 0 0 1 100 100m-8 0a92 92 0 1 0-92 92a92.1 92.1 0 0 0 92-92" />
											</svg>
										<?php elseif ( $event['code'] === 'OEC' && $event['type'] == '01' ) : ?>

											<svg width="266" height="187" viewBox="0 0 266 187" fill="none"
												xmlns="http://www.w3.org/2000/svg">
												<path
													d="M82 53C82 50.7909 83.7909 49 86 49H94C96.2091 49 98 50.7909 98 53C98 55.2091 96.2091 57 94 57H86C83.7909 57 82 55.2091 82 53Z"
													fill="#2271b1" />
												<path
													d="M64 91C61.7909 91 60 92.7909 60 95C60 97.2091 61.7909 99 64 99H72C74.2091 99 76 97.2091 76 95C76 92.7909 74.2091 91 72 91H64Z"
													fill="#2271b1" />
												<path
													d="M39 72C36.7909 72 35 73.7909 35 76C35 78.2091 36.7909 80 39 80H83C85.2091 80 87 78.2091 87 76C87 73.7909 85.2091 72 83 72H39Z"
													fill="#2271b1" />
												<path fill-rule="evenodd" clip-rule="evenodd"
													d="M178.199 160H103.801C102.065 175.196 89.1611 187 73.5 187C57.8389 187 44.9348 175.196 43.1986 160H35C27.8203 160 22 154.18 22 147V99H4C1.79086 99 0 97.2091 0 95C0 92.7909 1.79086 91 4 91H22V80H18C15.7909 80 14 78.2091 14 76C14 73.7909 15.7909 72 18 72H22V57H13C10.7909 57 9 55.2091 9 53C9 50.7909 10.7909 49 13 49H22V13C22 5.82029 27.8203 0 35 0H162C169.18 0 175 5.82029 175 13V37H200C236.451 37 266 66.5492 266 103V155C266 157.761 263.761 160 261 160H238.801C237.065 175.196 224.161 187 208.5 187C192.839 187 179.935 175.196 178.199 160ZM30 49V13C30 10.2386 32.2386 8 35 8H162C164.761 8 167 10.2386 167 13V152H103.67C101.495 137.289 88.8158 126 73.5 126C58.1842 126 45.5051 137.289 43.3297 152H35C32.2386 152 30 149.761 30 147V99H48C50.2091 99 52 97.2091 52 95C52 92.7909 50.2091 91 48 91H30V57H65C67.2091 57 69 55.2091 69 53C69 50.7909 67.2091 49 65 49H30ZM175 152V45H200C232.033 45 258 70.9675 258 103V152H238.67C236.495 137.289 223.816 126 208.5 126C193.184 126 180.505 137.289 178.33 152H175ZM96 156.5C96 168.926 85.9264 179 73.5 179C61.0736 179 51 168.926 51 156.5C51 144.074 61.0736 134 73.5 134C85.9264 134 96 144.074 96 156.5ZM231 156.5C231 168.926 220.926 179 208.5 179C196.074 179 186 168.926 186 156.5C186 144.074 196.074 134 208.5 134C220.926 134 231 144.074 231 156.5Z"
													fill="#2271b1" />
											</svg>

										<?php elseif ( $event['code'] === 'BDE' && $event['type'] == '20' ) : ?>

											<svg width="256" height="256" viewBox="0 0 256 256" fill="none"
												xmlns="http://www.w3.org/2000/svg">
												<path fill-rule="evenodd" clip-rule="evenodd"
													d="M118.081 32.8823L126.08 28.5002C126.667 28.1727 127.328 28.0007 128 28.0007C128.672 28.0007 129.333 28.1727 129.92 28.5002L216.67 76.0002L178.5 96.8902C178.319 96.7401 178.125 96.6062 177.92 96.4902L119.588 64.5534C118.995 67.2494 118.223 69.8779 117.283 72.4259L170.23 101.41L128 124.5L90.5548 104.019C87.6983 105.657 84.6955 107.069 81.5707 108.23L124 131.45V226.36L38.0802 179.3C37.4519 178.956 36.9274 178.45 36.5616 177.835C36.1957 177.219 36.0018 176.516 36.0002 175.8V106.834C33.2167 105.6 30.5437 104.162 28.0002 102.539V175.82C28.0015 177.972 28.5814 180.084 29.6792 181.935C30.7771 183.786 32.3524 185.307 34.2402 186.34L122.24 234.52C124.005 235.491 125.986 236 128 236C130.014 236 131.996 235.491 133.76 234.52L221.76 186.34C223.648 185.307 225.223 183.786 226.321 181.935C227.419 180.084 227.999 177.972 228 175.82V80.1802C227.999 78.0283 227.419 75.9163 226.321 74.0655C225.223 72.2147 223.648 70.6931 221.76 69.6602L133.76 21.4802C131.994 20.5139 130.013 20.0074 128 20.0074C125.987 20.0074 124.006 20.5139 122.24 21.4802L115.093 25.3933C116.249 27.8055 117.249 30.3061 118.081 32.8823ZM217.92 179.3L132 226.3V131.45L172 109.56V152C172 153.061 172.422 154.078 173.172 154.829C173.922 155.579 174.939 156 176 156C177.061 156 178.078 155.579 178.829 154.829C179.579 154.078 180 153.061 180 152V105.18L220 83.2902V175.82C219.999 176.536 219.805 177.239 219.439 177.855C219.073 178.47 218.548 178.976 217.92 179.32V179.3Z"
													fill="#2271B1" />
												<path
													d="M59.457 5C39.4961 5 22.8047 17.3438 16 34.7852L23.2031 37.7148C28.8945 23.125 42.6992 12.8125 59.457 12.8125C72.1133 12.8125 83.418 19.0234 90.4648 28.4375H75.082V36.25H102.426V8.90625H94.6133V20.9922C90.2371 15.9683 84.8345 11.9413 78.7699 9.18255C72.7053 6.42383 66.1196 4.99758 59.457 5ZM95.707 66.0352C90.0195 80.625 76.2148 90.9375 59.457 90.9375C46.6602 90.9375 35.4062 84.6406 28.3242 75.3125H43.832V67.5H16.4883V94.8438H24.3008V82.7578C32.8555 92.4453 45.375 98.75 59.457 98.75C79.418 98.75 96.1094 86.4062 102.914 68.9648L95.707 66.0352Z"
													fill="#2271B1" />
											</svg>
										<?php elseif ( $event['code'] === 'BDE' && $event['type'] == '02' ) : ?>
											<svg width="256" height="256" viewBox="0 0 256 256" fill="none"
												xmlns="http://www.w3.org/2000/svg">
												<path fill-rule="evenodd" clip-rule="evenodd"
													d="M86.9073 22.0741L79.9257 15.0925L48.9998 46.0675L18.0739 15.0925L11.0923 22.0741L42.0673 53L11.0923 83.9259L18.0739 90.9075L48.9998 59.9325L79.9257 90.9075L86.9073 83.9259L55.9323 53L86.9073 22.0741Z"
													fill="#2271B1" />
												<path fill-rule="evenodd" clip-rule="evenodd"
													d="M111.002 38.562C109.457 38.749 107.894 38.0323 107.069 36.6002C105.945 34.6479 106.617 32.1055 108.57 30.9216L111.205 29.3246L118.24 25.4728C120.006 24.5065 121.987 24 124 24C126.013 24 127.994 24.5065 129.76 25.4728L217.76 73.6528C219.648 74.6857 221.223 76.2073 222.321 78.0581C223.419 79.9089 223.999 82.0209 224 84.1728V179.813C223.999 181.965 223.419 184.077 222.321 185.927C221.223 187.778 219.648 189.3 217.76 190.333L129.76 238.513C127.995 239.484 126.014 239.993 124 239.993C121.986 239.993 120.005 239.484 118.24 238.513L30.24 190.333C28.3522 189.3 26.7769 187.778 25.6791 185.927C24.5812 184.077 24.0013 181.965 24 179.813V114.061C24.5805 112.357 26.1887 111.116 28.0938 111.084C29.7841 111.056 31.2597 111.987 32 113.374V179.793C32.0016 180.509 32.1955 181.212 32.5614 181.827C32.9273 182.443 33.4517 182.949 34.08 183.293L120 230.353V135.443L85.4706 116.546C84.4058 115.204 84.1803 113.265 85.0445 111.654C85.9011 110.057 87.5807 109.244 89.2196 109.469L124 128.493L166.23 105.403L108.63 73.8713C107.43 72.5837 107.139 70.6201 108.044 69.0017C109.008 67.2808 111.012 66.5097 112.828 67.0349L173.92 100.483C174.125 100.599 174.319 100.733 174.5 100.883L212.67 79.9928L125.92 32.4928C125.333 32.1652 124.672 31.9933 124 31.9933C123.328 31.9933 122.667 32.1652 122.08 32.4928L111.002 38.562ZM128 230.293L213.92 183.293V183.313C214.548 182.969 215.073 182.463 215.439 181.847C215.804 181.232 215.998 180.529 216 179.813V87.2828L176 109.173V155.993C176 157.054 175.579 158.071 174.828 158.821C174.078 159.571 173.061 159.993 172 159.993C170.939 159.993 169.922 159.571 169.172 158.821C168.421 158.071 168 157.054 168 155.993V113.553L128 135.443V230.293Z"
													fill="#2271B1" />
											</svg>
										<?php elseif ( $event['code'] === 'LDI' && $event['type'] == '01' ) : ?>
											<svg width="215" height="215" viewBox="0 0 215 215" fill="none"
												xmlns="http://www.w3.org/2000/svg">
												<path fill-rule="evenodd" clip-rule="evenodd"
													d="M183.699 125.865V97.6101C187.48 94.7494 190.245 91.0167 191.995 86.4122C193.745 81.8076 193.78 76.9402 192.102 71.8101L179.471 31.3542H35.2776L22.9957 71.8101C21.3235 76.9402 21.3623 81.7688 23.1122 86.2957C24.8621 90.8227 27.6272 94.4806 31.4076 97.2697V183.646H123.023C121.236 180.864 119.764 177.861 118.657 174.688H40.3659V101.883C41.5007 102.295 42.6294 102.588 43.7522 102.761C44.869 102.934 45.9798 103.021 47.0847 103.021C49.2466 103.021 51.97 102.471 55.2547 101.373C58.5454 100.28 62.3915 97.5324 66.793 93.1309C69.4805 96.8576 72.607 99.4376 76.1724 100.871C79.7378 102.304 83.3988 103.021 87.1553 103.021C90.4639 103.021 93.9398 102.188 97.5828 100.522C101.232 98.8553 104.555 96.3917 107.553 93.1309C110.808 96.3917 114.048 98.8553 117.273 100.522C120.498 102.188 123.896 103.021 127.468 103.021C132.383 103.015 136.558 102.095 139.992 100.262C143.426 98.4283 146.313 96.0543 148.654 93.1399C151.407 96.5858 154.316 99.0942 157.38 100.665C160.443 102.236 163.991 103.021 168.022 103.021C169.127 103.021 170.22 102.934 171.301 102.761C172.388 102.594 173.535 102.301 174.741 101.883V120.975C177.935 122.248 180.939 123.897 183.699 125.865ZM140.144 89.2251C137.307 92.4501 133.013 94.0626 127.262 94.0626C123.129 94.0626 119.567 92.474 116.557 89.2968C113.547 86.1255 112.042 82.3391 112.042 77.9376V40.3126H137.779L143.727 79.2455C144.175 82.6795 142.981 86.0061 140.144 89.2251ZM98.631 89.2968C95.6628 92.474 91.7718 94.0626 86.9582 94.0626C81.7982 94.0566 77.8118 92.3963 75.0168 89.0817C72.2218 85.7672 71.0064 82.7183 71.3707 79.9353L77.337 40.3126H103.083V77.9376C103.083 82.3331 101.599 86.1195 98.631 89.2968ZM57.1539 90.0313C54.3887 92.7188 51.0323 94.0626 47.0847 94.0626C40.9154 94.0686 36.4661 91.8648 33.7368 87.4513C31.0075 83.0379 30.3804 78.4781 31.8555 73.7719L41.6739 40.3126H67.9307L62.3139 79.9711C61.639 83.9904 59.919 87.3438 57.1539 90.0313ZM180.868 87.7917C177.667 91.9723 173.385 94.0626 168.022 94.0626C164.075 94.0626 160.718 92.7188 157.953 90.0313C155.188 87.3438 153.468 83.9904 152.793 79.9711L147.176 40.3126H173.155L183.251 73.7719C184.87 78.9379 184.076 83.6112 180.868 87.7917Z"
													fill="#2271B1" />
												<path
													d="M154.766 160.623C154.766 162.933 156.639 164.805 158.949 164.805H179.864C182.174 164.805 184.047 162.933 184.047 160.623C184.047 158.312 182.174 156.44 179.864 156.44H163.132V139.708C163.132 137.398 161.259 135.525 158.949 135.525C156.639 135.525 154.766 137.398 154.766 139.708V160.623Z"
													fill="#2271B1" />
												<path fill-rule="evenodd" clip-rule="evenodd"
													d="M201.615 160.623C201.615 184.186 182.513 203.288 158.949 203.288C135.386 203.288 116.284 184.186 116.284 160.623C116.284 137.059 135.386 117.957 158.949 117.957C182.513 117.957 201.615 137.059 201.615 160.623ZM193.249 160.623C193.249 179.566 177.892 194.922 158.949 194.922C140.006 194.922 124.65 179.566 124.65 160.623C124.65 141.679 140.006 126.323 158.949 126.323C177.892 126.323 193.249 141.679 193.249 160.623Z"
													fill="#2271B1" />
											</svg>
										<?php else : ?>
											<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256">
												<path fill="#2271b1"
													d="m221.76 69.66l-88-48.18a12 12 0 0 0-11.52 0l-88 48.18A12 12 0 0 0 28 80.18v95.64a12 12 0 0 0 6.24 10.52l88 48.18a11.95 11.95 0 0 0 11.52 0l88-48.18a12 12 0 0 0 6.24-10.52V80.18a12 12 0 0 0-6.24-10.52M126.08 28.5a3.94 3.94 0 0 1 3.84 0L216.67 76L178.5 96.89a4 4 0 0 0-.58-.4l-88-48.18Zm1.92 96L39.33 76l42.23-23.13l88.67 48.54Zm-89.92 54.8a4 4 0 0 1-2.08-3.5V83.29l88 48.16v94.91Zm179.84 0l-85.92 47v-94.85l40-21.89V152a4 4 0 0 0 8 0v-46.82l40-21.89v92.53a4 4 0 0 1-2.08 3.5Z" />
											</svg>
										<?php endif; ?>
									</div>
								</div>
								<div>
									<div class="infixs-caref-order-tracking-event-title">
										<?php echo esc_html( $event['description'] ); ?>
									</div>
									<?php if ( $event['code'] === 'LDI' && $event['type'] == '01' ) : ?>
										<div class="infixs-caref-order-tracking-event-address">
											<?php
											echo esc_html( $event['location']['address'] );
											if ( isset( $event['location']['number'] ) ) {
												echo sprintf( ", %s", esc_html( $event['location']['number'] ) );
											}
											if ( isset( $event['location']['neighborhood'] ) ) {
												echo sprintf( " - %s", esc_html( $event['location']['neighborhood'] ) );
											}
											?>
										</div>
									<?php endif; ?>
									<div class="infixs-caref-order-tracking-event-address">
										<?php echo esc_html( $event['location']['city'] ); ?>/<?php echo esc_html( $event['location']['state'] ); ?>
									</div>
									<?php if ( isset( $event['detail'] ) ) : ?>
										<p>
											<?php echo esc_html( $event['detail'] ); ?>
										</p>
									<?php endif; ?>
									<div class="infixs-caref-date">
										<?php echo esc_html( Formatter::format_timestamp( strtotime( $event['event_date'] ) ) ); ?>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
						<div class="infixs-caref-order-tracking-row">
							<div>
								<div class="infixs-caref-order-tracking-icon">
									<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256">
										<path fill="#2271b1"
											d="m221.76 69.66l-88-48.18a12 12 0 0 0-11.52 0l-88 48.18A12 12 0 0 0 28 80.18v95.64a12 12 0 0 0 6.24 10.52l88 48.18a11.95 11.95 0 0 0 11.52 0l88-48.18a12 12 0 0 0 6.24-10.52V80.18a12 12 0 0 0-6.24-10.52M126.08 28.5a3.94 3.94 0 0 1 3.84 0L216.67 76L178.5 96.89a4 4 0 0 0-.58-.4l-88-48.18Zm1.92 96L39.33 76l42.23-23.13l88.67 48.54Zm-89.92 54.8a4 4 0 0 1-2.08-3.5V83.29l88 48.16v94.91Zm179.84 0l-85.92 47v-94.85l40-21.89V152a4 4 0 0 0 8 0v-46.82l40-21.89v92.53a4 4 0 0 1-2.08 3.5Z" />
									</svg>
								</div>
							</div>
							<div>
								<div class="infixs-caref-order-tracking-event-title">
									Preparando para envio
								</div>
								<p>
									Seu pedido está sendo preparado para envio, você será avisado por e-mail sempre que houver
									uma
									atualização da entrega.
								</p>
								<?php if ( isset( $order ) ) : ?>
									<div class="infixs-caref-date">
										<?php echo esc_html( Formatter::format_timestamp( $order->get_date_created()->getTimestamp() ) ); ?>
									</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
				<?php if ( $show_more ) : ?>
					<div class="infixs-caref-order-tracking-show-more-button-wrap">
						<a href="#" class="infixs-caref-show-more-button">Ver todo histórico</a>
					</div>
				<?php endif; ?>
			</div>
		<?php endforeach; ?>
	<?php else : ?>
		<div class="infixs-caref-order-tracking-box">
			<?php if ( isset( $search ) && $search ) : ?>
				<div class="infixs-caref-order-tracking-info">
					<p>Ainda não há eventos de rastreamento para o código selecionado, tente outro.</p>
					<a href="https://rastreamento.correios.com.br/app/index.php" target="_blank"
						class="button button-primary">Rastrear Site dos Correios</a>
				</div>
			<?php else : ?>
				<div class="infixs-caref-order-tracking-info">
					<p>Ainda não há códigos de rastreamento para esse pedido.</p>
					<a href="https://rastreamento.correios.com.br/app/index.php" target="_blank"
						class="button button-primary">Rastrear Site dos Correios</a>
				</div>
			<?php endif; ?>
		</div>
	<?php endif; ?>
</div>