<?php

add_action( 'woocommerce_after_add_to_cart_button', 'tabela_medidas_popup' );
function tabela_medidas_popup() {
    ?>
    <!-- Botão para abrir o popup -->
    <div class="tabela-medidas" style="margin-top:22px;">
        <a href="#" id="abrirTabela" style="color:#000; text-decoration:none; font-weight:bold;">
            📏 Tabela de Medidas
        </a>
    </div>

    <!-- Estrutura do popup -->
    <div id="popupTabela" class="popup-tabela">
        <div class="popup-conteudo">
            <span class="fechar">&times;</span>
            <img src="https://datemomentos.store/wp-content/uploads/tabeladate.png" alt="Tabela de Medidas" style="max-width:100%; height:auto; border-radius:8px;">
        </div>
    </div>

    <!-- CSS do popup -->
    <style>
        .popup-tabela {
            display: none;
            position: fixed;
            z-index: 9999;
            padding-top: 80px;
            left: 0; top: 0;
            width: 100%; height: 100%;
            background-color: rgba(0,0,0,0.6);
        }
        .popup-conteudo {
            background: #fff;
            margin: auto;
            padding: 15px;
            border-radius: 12px;
            width: 90%;
            max-width: 600px;
            box-shadow: 0 8px 20px rgba(0,0,0,0.4);
            animation: fadeIn 0.3s ease;
            text-align: center;
        }
        .fechar {
            color: #555;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }
        .fechar:hover {
            color: #000;
        }
        #abrirTabela {
            color: #000 !important;
            text-decoration: none !important;
        }
        #abrirTabela:hover {
            color: #444 !important;
        }
        @keyframes fadeIn {
            from {opacity: 0; transform: scale(0.9);}
            to {opacity: 1; transform: scale(1);}
        }
    </style>

    <!-- JS para abrir/fechar -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            var popup = document.getElementById("popupTabela");
            var btn = document.getElementById("abrirTabela");
            var span = popup.querySelector(".fechar");

            btn.onclick = function(e) {
                e.preventDefault();
                popup.style.display = "block";
            }

            span.onclick = function() {
                popup.style.display = "none";
            }

            window.onclick = function(event) {
                if (event.target == popup) {
                    popup.style.display = "none";
                }
            }
        });
    </script>
    <?php
}

add_action( 'woocommerce_before_main_content', 'banner_categoria_sexshop' );
function banner_categoria_sexshop() {
    // Verifica se estamos na categoria 'sexshop'
    if ( is_product_category( 'sexshop' ) ) {
        echo '<div class="meu-banner-categoria" style="text-align:center; margin-bottom:20px;">
                <img src="https://datemomentos.store/wp-content/uploads/Rifa-2.png" alt="Banner Sexshop" style="max-width:100%; height:auto;">
              </div>';
    }
}

add_action('wp_footer','abrir_addonify_cart_ao_adicionar', 999);
function abrir_addonify_cart_ao_adicionar(){
    ?>
    <script>
    jQuery(function($){
        // Quando um produto for adicionado ao carrinho
        $(document.body).on('added_to_cart', function(){
            if (typeof Addonify_Side_Cart !== 'undefined' && typeof Addonify_Side_Cart.open === 'function') {
                Addonify_Side_Cart.open();
            }
        });
    });
    </script>
    <?php
}

// Traduzir/alterar o texto da checkbox de Termos e Condições
add_filter( 'woocommerce_get_terms_and_conditions_checkbox_text', 'meu_texto_termos' );
function meu_texto_termos( $text ) {
    $text = sprintf( 'Li e concordo com os %s', '<a href="' . esc_url( wc_get_page_permalink( 'terms' ) ) . '" target="_blank">Termos e Condições</a>' );
    return $text;
}