<?php
/**
 * The template for displaying Archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package BOXY
 */

get_header(); ?>
<div id="content" class="site-content container">
<div class="row">
<?php do_action('boxy_two_sidebar_left'); ?>	

	<div id="primary" class="content-area <?php boxy_layout_class(); ?> columns">
		<main id="main" class="site-main blog-content" role="main">

		<?php if ( have_posts() ) : ?>

			<header class="page-header">
				<h1 class="page-title">
				<?php
					if ( is_category() ) :
						printf( '%1$s: %2$s',__('Category','boxy' ), '<span class="vcard">' . single_cat_title( '', false ) . '</span>' );

					elseif ( is_tag() ) :
						printf( '%1$s: %2$s',__('Tag','boxy' ), '<span class="vcard">' . single_tag_title( '', false ) . '</span>' );

					elseif ( is_author() ) :
						printf( '%1$s: %2$s',__('Author','boxy' ), '<span class="vcard">' . get_the_author() . '</span>' );

					elseif ( is_day() ) :
						printf( '%1$s: %2$s',__('Day','boxy' ), '<span>' . get_the_date() . '</span>' );

					elseif ( is_month() ) :
						printf( '%1$s: %2$s',__('Month','boxy' ), '<span>' . get_the_date( _x( 'F Y', 'monthly archives date format', 'boxy' ) ) . '</span>' );

					elseif ( is_year() ) :
						printf( '%1$s: %2$s',__('Year','boxy' ), '<span>' . get_the_date( _x( 'Y', 'yearly archives date format', 'boxy' ) ) . '</span>' );

					elseif ( is_tax( 'post_format', 'post-format-aside' ) ) :
						_e( 'Asides', 'boxy' );

					elseif ( is_tax( 'post_format', 'post-format-gallery' ) ) :
						_e( 'Galleries', 'boxy' );

					elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
						_e( 'Images', 'boxy' );

					elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
						_e( 'Videos', 'boxy' );

					elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
						_e( 'Quotes', 'boxy' );

					elseif ( is_tax( 'post_format', 'post-format-link' ) ) :
						_e( 'Links', 'boxy' );

					elseif ( is_tax( 'post_format', 'post-format-status' ) ) :
						_e( 'Statuses', 'boxy' );

					elseif ( is_tax( 'post_format', 'post-format-audio' ) ) :
						_e( 'Audios', 'boxy' );

					elseif ( is_tax( 'post_format', 'post-format-chat' ) ) :
						_e( 'Chats', 'boxy' );

					else :
						_e( 'Archives', 'boxy' );

					endif;
				?>
				</h1>
			<?php
				// Show an optional term description.
				$term_description = term_description();
				if ( ! empty( $term_description ) ) :
					printf( '<div class="taxonomy-description">%s</div>', $term_description );
				endif;
			?>
			</header><!-- .page-header -->

			<?php while ( have_posts() ) : the_post(); ?>

				<?php
					/* Include the Post-Format-specific template for the content.
					 * If you want to override this in a child theme, then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */
					get_template_part( 'content', get_post_format() );
				?>

			<?php endwhile; ?>

	<?php 
		if(  get_theme_mod ('numeric_pagination',true) && function_exists( 'boxy_pagination' ) ) : 
				boxy_pagination();
			else :
				boxy_post_nav();     
			endif; 
	?>

		<?php else : ?>

			<?php get_template_part( 'content', 'none' ); ?>

		<?php endif; ?>

		</main><!-- #main -->
	</div><!-- #primary -->

	 <?php do_action('boxy_two_sidebar_right'); ?>	

	
<?php get_footer(); ?>
