<?php 
    add_action( 'wp_enqueue_scripts', 'enqueue_parent_styles' ); 

    function enqueue_parent_styles() { 
      wp_enqueue_style( 'parent-style', get_template_directory_uri().'/style.css' ); 
    } 

    function registro_espaco_widgets() {
      register_sidebar( array(
        'name' => 'Menu smartphone',
        'id'   => 'menu_smartphone',
        'description' => 'Area widget das categorias apenas para smartphone',
      ) );

    }
    add_action ( 'widgets_init', 'registro_espaco_widgets' );

    //Remove JQuery migrate
    function remove_jquery_migrate($scripts)
    {
    if (!is_admin() && isset($scripts->registered['jquery'])) {
    $script = $scripts->registered['jquery'];

    if ($script->deps) { // Check whether the script has any dependencies
    $script->deps = array_diff($script->deps, array(
    'jquery-migrate'
    ));
    }
    }
    }
    add_action('wp_default_scripts', 'remove_jquery_migrate');

/* Theme Setup */
if ( ! function_exists( 'vw_security_guard_setup' ) ) :
 
function vw_security_guard_setup() {

	$GLOBALS['content_width'] = apply_filters( 'vw_security_guard_content_width', 640 );
	
	load_theme_textdomain( 'vw-security-guard', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'custom-logo', array(
		'height'      => 350,
		'width'       => 350,
		'flex-height' => true,
	) );
	add_image_size('vw-security-guard-homepage-thumb',240,145,true);
	
       register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'vw-security-guard' ),
	) );

	add_theme_support( 'custom-background', array(
		'default-color' => 'ffffff'
	) );

	/*
	 * Enable support for Post Formats.
	 *
	 * See: https://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array('image','video','gallery','audio',) );
	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, icons, and column width.
	 */
	add_editor_style( array( 'css/editor-style.css', vw_security_guard_font_url() ) );
}
endif;


?>