<?php
/**
 * The template part for displaying a message that posts cannot be found.
 *
 * @package VW Security Guard
 */
?>

<div class="title-box">
    <div class="container">
        <h2 class="entry-title"><?php esc_html_e( 'Nada encontrado', 'vw-security-guard' ); ?></h2>
    </div>
</div>

<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

	<p><?php printf( esc_html__( 'Pronto para publicar seu primeiro post? Comece aqui.', 'vw-security-guard' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>
	<?php elseif ( is_search() ) : ?>
	<p><?php esc_html_e( 'Desculpe, mas nada corresponde aos seus termos de pesquisa. Por favor, tente novamente com algumas palavras-chave diferentes.', 'vw-security-guard' ); ?></p><br />
		<?php get_search_form(); ?>
	<?php else : ?>
	<p><?php esc_html_e( 'Dont worry&hellip it happens to the best of us.', 'vw-security-guard' ); ?></p><br />
	<div class="error-btn">
		<a href="<?php echo esc_url(home_url() ); ?>"><?php esc_html_e( 'Back to Home Page', 'vw-security-guard' ); ?><span class="screen-reader-text"><?php esc_html_e( 'Back to Home Page','vw-security-guard' );?></span></a>
	</div>
<?php endif; ?>