<?php
/**
 * The template part for header
 *
 * @package VW Security Guard 
 * @subpackage vw_security_guard
 * @since VW Security Guard 1.0
 */
?>

<div id="top-header">
  <div class="container">
    <div class="row">
      <div class="logo col-lg-4 col-md-12">
        <?php if( has_custom_logo() ){ vw_security_guard_the_custom_logo();
          }else{ ?>
          <h1><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
          <?php $description = get_bloginfo( 'description', 'display' );
          if ( $description || is_customize_preview() ) : ?>
          <p class="site-description"><?php echo esc_html($description); ?></p>
        <?php endif; } ?>
      </div>
      <div class="mid-header col-lg-8 col-md-12">
        <div class="row m-0">
          
          <div class="col-lg-7 col-md-8">
            <div class="row">
            		<p>
						<?php 
            // get_search_form() 
            echo do_shortcode('[wcas-search-form]');
            ?>
					</p>
            </div>
          </div>
          <div class="col-lg-5 col-md-5">
            <div class="row">
              <?php if ( get_theme_mod('vw_security_guard_time_text','') != "" ) {?>
                <div class="col-lg-12 col-md-12 col-12 p-0 icon">
                 	<i class="fa fa-user-circle login"></i>
					<?php if ( is_user_logged_in() ) : $usuario_atual = wp_get_current_user(); ?>
							<p class="bold-font login"><a href="https://csbcomercial.com.br/minha-conta/" class="login-link1">Bem vindo, 																<?php echo $usuario_atual->display_name; ?></a><br><a href="/minha-conta" 																	class="login-link2">Minha Conta </a>  <span> | <a href="/minha-conta/orders/"                                  class="login-link2">Meus pedidos</a>  <span> | </span><a href="<?php echo wp_logout_url( home_url() ); ?>"> Sair</a></p><br/>
					<div style="clear: both;"></div>
					<?php else: ?>
						<p class="bold-font login">Entre ou Cadastre-se<br>
              <a href="https://csbcomercial.com.br/wp-login.php" class="login-link2">Entrar</a> - <a href="https://csbcomercial.com.br/cadastre-se" class="login-link2">Cadastrar</a></p><br/>
					<div style="clear: both;"></div>
					<?php endif; ?>
				</div>
				<?php }?>	
             </div>
            </div>
          </div>
        </div>        
      </div>
    </div>
  </div>
</div>