<?php
namespace Mediavine\Grow;

class Network_Icons {
	/** @var array[]  */
	public static $icons = [
		'facebook'   => [
			'paths'  => [ 'M17.12 0.224v4.704h-2.784q-1.536 0-2.080 0.64t-0.544 1.92v3.392h5.248l-0.704 5.28h-4.544v13.568h-5.472v-13.568h-4.544v-5.28h4.544v-3.904q0-3.328 1.856-5.152t4.96-1.824q2.624 0 4.064 0.224z' ],
			'width'  => 18,
			'height' => 32,
			'pro'    => false,
		],
		'twitter'    => [
			'paths'  => [ 'M28.928 7.296q-1.184 1.728-2.88 2.976 0 0.256 0 0.736 0 2.336-0.672 4.64t-2.048 4.448-3.296 3.744-4.608 2.624-5.792 0.96q-4.832 0-8.832-2.592 0.608 0.064 1.376 0.064 4.032 0 7.168-2.464-1.888-0.032-3.36-1.152t-2.048-2.848q0.608 0.096 1.088 0.096 0.768 0 1.536-0.192-2.016-0.416-3.328-1.984t-1.312-3.68v-0.064q1.216 0.672 2.624 0.736-1.184-0.8-1.888-2.048t-0.704-2.752q0-1.568 0.8-2.912 2.176 2.656 5.248 4.256t6.656 1.76q-0.16-0.672-0.16-1.312 0-2.4 1.696-4.064t4.064-1.696q2.528 0 4.224 1.824 1.952-0.384 3.68-1.408-0.672 2.048-2.56 3.2 1.664-0.192 3.328-0.896z' ],
			'width'  => 31,
			'height' => 30,
			'pro'    => false,
		],
		'x'   		 => [
			'paths'  => [ 'M30.3 29.7L18.5 12.4l0 0L29.2 0h-3.6l-8.7 10.1L10 0H0.6l11.1 16.1l0 0L0 29.7h3.6l9.7-11.2L21 29.7H30.3z M8.6 2.7 L25.2 27h-2.8L5.7 2.7H8.6z' ],
			'width'  => 32,
			'height' => 30,
			'pro'    => false,
		],
		'pinterest'  => [
			'paths'  => [ 'M0 10.656q0-1.92 0.672-3.616t1.856-2.976 2.72-2.208 3.296-1.408 3.616-0.448q2.816 0 5.248 1.184t3.936 3.456 1.504 5.12q0 1.728-0.32 3.36t-1.088 3.168-1.792 2.656-2.56 1.856-3.392 0.672q-1.216 0-2.4-0.576t-1.728-1.568q-0.16 0.704-0.48 2.016t-0.448 1.696-0.352 1.28-0.48 1.248-0.544 1.12-0.832 1.408-1.12 1.536l-0.224 0.096-0.16-0.192q-0.288-2.816-0.288-3.36 0-1.632 0.384-3.68t1.184-5.152 0.928-3.616q-0.576-1.152-0.576-3.008 0-1.504 0.928-2.784t2.368-1.312q1.088 0 1.696 0.736t0.608 1.824q0 1.184-0.768 3.392t-0.8 3.36q0 1.12 0.8 1.856t1.952 0.736q0.992 0 1.824-0.448t1.408-1.216 0.992-1.696 0.672-1.952 0.352-1.984 0.128-1.792q0-3.072-1.952-4.8t-5.12-1.728q-3.552 0-5.952 2.304t-2.4 5.856q0 0.8 0.224 1.536t0.48 1.152 0.48 0.832 0.224 0.544q0 0.48-0.256 1.28t-0.672 0.8q-0.032 0-0.288-0.032-0.928-0.288-1.632-0.992t-1.088-1.696-0.576-1.92-0.192-1.92z' ],
			'width'  => 23,
			'height' => 32,
			'pro'    => false,
		],
		'linkedin'   => [
			'paths'  => [ 'M6.24 11.168v17.696h-5.888v-17.696h5.888zM6.624 5.696q0 1.312-0.928 2.176t-2.4 0.864h-0.032q-1.472 0-2.368-0.864t-0.896-2.176 0.928-2.176 2.4-0.864 2.368 0.864 0.928 2.176zM27.424 18.72v10.144h-5.856v-9.472q0-1.888-0.736-2.944t-2.272-1.056q-1.12 0-1.856 0.608t-1.152 1.536q-0.192 0.544-0.192 1.44v9.888h-5.888q0.032-7.136 0.032-11.552t0-5.28l-0.032-0.864h5.888v2.56h-0.032q0.352-0.576 0.736-0.992t0.992-0.928 1.568-0.768 2.048-0.288q3.040 0 4.896 2.016t1.856 5.952z' ],
			'width'  => 27,
			'height' => 32,
			'pro'    => false,
		],
		'email'      => [
			'paths'  => [ 'M18.56 17.408l8.256 8.544h-25.248l8.288-8.448 4.32 4.064zM2.016 6.048h24.32l-12.16 11.584zM20.128 15.936l8.224-7.744v16.256zM0 24.448v-16.256l8.288 7.776z' ],
			'width'  => 28,
			'height' => 32,
		],
		'print'      => [
			'paths'  => [ 'M27.712 9.152c1.28 0 2.4 1.12 2.4 2.496v11.712c0 1.344-1.12 2.464-2.4 2.464h-2.432l1.088 4.896h-22.112l0.864-4.896h-2.624c-1.44 0-2.496-1.12-2.496-2.464v-11.712c0-1.376 1.056-2.496 2.496-2.496h3.072v-3.744h1.088v-4.128h16.864v4.128h1.088v3.744h3.104zM7.776 2.784v9.344h14.624v-9.344h-14.624zM4.16 15.232c0.96 0 1.76-0.768 1.76-1.728 0-0.896-0.8-1.696-1.76-1.696-0.928 0-1.728 0.8-1.728 1.696 0 0.96 0.8 1.728 1.728 1.728zM6.176 29.248h18.144l-1.504-7.744h-15.488zM14.24 25.632h-4.448v-1.12h4.448v1.12zM20.576 25.632h-4.448v-1.12h4.448v1.12z' ],
			'width'  => 30,
			'height' => 32,
			'pro'    => false,
		],
		'reddit'     => [
			'paths'  => [ 'M0 15.616q0-0.736 0.288-1.408t0.768-1.184 1.152-0.8 1.472-0.288q1.376 0 2.368 0.928 1.888-1.184 4.32-1.888t5.184-0.8l2.56-7.296 6.272 1.504q0.288-0.832 1.056-1.344t1.696-0.544q1.248 0 2.144 0.864t0.896 2.144-0.896 2.112-2.112 0.864-2.144-0.864-0.896-2.112l-5.248-1.248-2.144 5.92q2.688 0.128 5.024 0.864t4.128 1.824q1.056-0.928 2.432-0.928 0.736 0 1.44 0.288t1.184 0.8 0.768 1.184 0.288 1.408q0 0.992-0.48 1.824t-1.28 1.312q0.128 0.544 0.128 1.12 0 1.92-1.12 3.712t-3.104 3.104-4.576 2.048-5.632 0.768q-2.944 0-5.568-0.768t-4.576-2.048-3.104-3.104-1.12-3.712q0-0.32 0.064-0.64 0-0.288 0.064-0.544-0.768-0.512-1.216-1.28t-0.48-1.792zM2.752 19.872q0 1.76 1.024 3.264t2.816 2.688 4.224 1.824 5.152 0.672 5.12-0.672 4.224-1.824 2.848-2.688 1.024-3.264-1.024-3.328-2.848-2.72-4.224-1.792-5.12-0.672-5.152 0.672-4.224 1.792-2.816 2.72-1.024 3.328zM9.12 18.144q0-0.896 0.704-1.6t1.6-0.672 1.6 0.672 0.672 1.6-0.672 1.568-1.6 0.672-1.6-0.672-0.704-1.568zM10.816 23.424q0.384-0.32 1.056 0.256 0.192 0.192 0.416 0.32t0.448 0.224 0.416 0.16 0.448 0.096 0.416 0.096 0.448 0.096 0.448 0.064 0.48 0.032 0.544 0.032q2.432-0.128 4.256-1.12 0.672-0.64 1.12-0.256 0.32 0.576-0.384 1.12-1.856 1.44-4.992 1.44-3.36-0.064-4.864-1.44-0.832-0.608-0.256-1.12zM18.56 18.112q0-0.928 0.672-1.6t1.6-0.64 1.632 0.64 0.672 1.6-0.672 1.6-1.632 0.672-1.6-0.672-0.672-1.6z' ],
			'width'  => 32,
			'height' => 32,
			'pro'    => true,
		],
		'vkontakte'  => [
			'paths'  => [ 'M34.24 9.28q0.416 1.152-2.688 5.248-0.416 0.576-1.152 1.536-0.704 0.896-0.992 1.28t-0.544 0.864-0.224 0.768 0.256 0.608 0.576 0.768 1.024 0.96q0.064 0.032 0.064 0.064 2.528 2.336 3.424 3.936 0.064 0.096 0.128 0.224t0.128 0.48-0.032 0.608-0.448 0.48-1.056 0.224l-4.544 0.096q-0.448 0.064-1.024-0.096t-0.928-0.416l-0.352-0.192q-0.544-0.384-1.248-1.152t-1.216-1.376-1.088-1.056-1.024-0.256q-0.032 0-0.128 0.064t-0.32 0.256-0.384 0.512-0.288 0.928-0.128 1.408q0 0.256-0.064 0.48t-0.128 0.32l-0.064 0.096q-0.32 0.352-0.96 0.384h-2.048q-1.28 0.096-2.592-0.288t-2.368-0.928-1.824-1.184-1.28-1.024l-0.448-0.448q-0.16-0.16-0.48-0.544t-1.28-1.6-1.888-2.72-2.176-3.744-2.336-4.864q-0.128-0.288-0.128-0.48t0.064-0.288l0.064-0.096q0.288-0.352 1.024-0.352l4.896-0.032q0.224 0.032 0.416 0.096t0.288 0.16l0.096 0.064q0.288 0.192 0.416 0.576 0.352 0.896 0.832 1.824t0.736 1.472l0.288 0.512q0.512 1.088 0.992 1.856t0.864 1.216 0.736 0.704 0.608 0.256 0.48-0.096q0.032-0.032 0.096-0.096t0.224-0.384 0.224-0.832 0.16-1.472 0-2.208q-0.032-0.736-0.16-1.312t-0.224-0.832l-0.128-0.192q-0.448-0.608-1.504-0.768-0.256-0.064 0.096-0.448 0.256-0.32 0.672-0.544 0.928-0.448 4.256-0.416 1.472 0.032 2.4 0.224 0.384 0.096 0.608 0.256t0.384 0.416 0.16 0.576 0.064 0.8 0 0.992-0.064 1.28 0 1.472q0 0.192-0.032 0.736t0 0.864 0.064 0.704 0.192 0.704 0.416 0.448q0.128 0.032 0.288 0.064t0.48-0.192 0.672-0.608 0.928-1.216 1.216-1.92q1.056-1.856 1.92-4 0.064-0.192 0.16-0.32t0.192-0.192l0.096-0.064 0.064-0.032t0.256-0.064 0.352 0l5.12-0.032q0.704-0.096 1.152 0.032t0.544 0.32z' ],
			'width'  => 34,
			'height' => 32,
			'pro'    => true,
		],
		'whatsapp'   => [
			'paths'  => [ 'M17.6 17.376q0.224 0 1.728 0.8t1.6 0.96q0.032 0.064 0.032 0.256 0 0.576-0.288 1.344-0.288 0.704-1.28 1.184t-1.824 0.48q-1.024 0-3.392-1.12-1.76-0.8-3.040-2.112t-2.624-3.296q-1.312-1.92-1.28-3.456v-0.16q0.064-1.6 1.312-2.816 0.448-0.384 0.928-0.384 0.128 0 0.32 0.032t0.352 0.032q0.352 0 0.48 0.096t0.256 0.512q0.16 0.352 0.608 1.568t0.448 1.312q0 0.384-0.608 1.056t-0.64 0.832q0 0.096 0.096 0.256 0.608 1.312 1.824 2.432 0.992 0.96 2.688 1.824 0.224 0.128 0.416 0.128 0.256 0 0.96-0.864t0.928-0.896zM13.952 26.848q2.272 0 4.352-0.896t3.584-2.368 2.4-3.584 0.896-4.352-0.896-4.352-2.4-3.584-3.584-2.4-4.352-0.896-4.32 0.896-3.584 2.4-2.4 3.584-0.896 4.352q0 3.616 2.144 6.56l-1.408 4.16 4.32-1.376q2.816 1.856 6.144 1.856zM13.952 2.176q2.752 0 5.248 1.088t4.288 2.848 2.88 4.32 1.056 5.216-1.056 5.216-2.88 4.288-4.288 2.88-5.248 1.088q-3.456 0-6.496-1.696l-7.456 2.4 2.432-7.232q-1.92-3.168-1.92-6.944 0-2.752 1.056-5.216t2.88-4.32 4.288-2.848 5.216-1.088z' ],
			'width'  => 27,
			'height' => 32,
			'pro'    => true,
		],
		'pocket'     => [
			'paths'  => [ 'M0.064 10.56q-0.224-6.88 0.384-8.64 0.128-0.288 0.288-0.512t0.448-0.384 0.448-0.32 0.544-0.32 0.544-0.256q4.352 0 12.352-0.064t10.528-0.064h3.008t1.76 0 1.792 0.096 1.44 0.192 1.056 0.32q0.512 0.288 0.864 0.768t0.512 0.928 0.256 1.28 0.064 1.344-0.032 1.6 0 1.6q0 6.624-0.736 10.464t-3.072 6.816q-2.24 2.816-5.28 4.48t-6.176 1.984-6.4-0.352-5.952-2.336-4.832-4.288-3.072-5.792q-0.48-1.664-0.736-8.544zM7.488 10.496q-0.832 0.896 0.48 2.848t3.328 3.968q0.064 0.064 1.248 1.28t1.728 1.664 1.504 1.12 1.824 0.928q0.352 0.096 0.704 0.096t0.64-0.032 0.608-0.224 0.512-0.224 0.512-0.384 0.384-0.32 0.384-0.352l0.096-0.096q0.288-0.288 1.92-1.792t2.752-2.592 2.176-2.528 1.12-2.4q-0.48-1.28-1.216-1.792t-1.632-0.288-1.792 0.832-1.888 1.536-1.792 1.792-1.568 1.632-1.184 1.056q-0.864-0.512-2.336-1.92t-2.624-2.624-2.336-2.048-1.76-0.448q-0.8 0.48-1.792 1.312z' ],
			'width'  => 36,
			'height' => 32,
			'pro'    => true,
		],
		'yummly'     => [
			'paths'  => [ 'M4.576 0.128c-0.032 0.032-0.16 0.064-0.32 0.064-0.576 0.096-1.216 0.288-1.376 0.384-0.064 0.064-0.128 0.064-0.16 0.032s-0.032 0-0.032 0.064c0 0.064-0.032 0.064-0.064 0.064-0.096-0.096-1.504 0.672-1.888 1.024-0.16 0.16-0.32 0.288-0.32 0.256s-0.096 0.096-0.192 0.288c-0.16 0.256-0.192 0.416-0.192 0.672 0.032 0.224 0.096 0.448 0.16 0.512 0.032 0.064 0.064 0.096 0.032 0.096-0.096 0 0.064 0.288 0.384 0.768 0.16 0.224 0.32 0.416 0.384 0.416 0.032 0 0.096 0.032 0.064 0.064-0.032 0.128 0.384 0.416 0.576 0.416 0.128 0 0.32-0.128 0.544-0.32 0.16-0.192 0.352-0.32 0.352-0.32 0.032 0 0.192-0.096 0.384-0.224 0.704-0.48 1.6-0.608 1.856-0.288 0.064 0.064 0.16 0.128 0.192 0.096 0.064-0.032 0.064-0.032 0.032 0.032s-0.032 0.192 0 0.288c0.032 0.096 0.032 0.352 0 0.576-0.032 0.192-0.096 0.48-0.096 0.576-0.032 0.128-0.096 0.384-0.16 0.544-0.032 0.192-0.096 0.384-0.096 0.448-0.032 0.032-0.096 0.288-0.16 0.544-0.096 0.256-0.16 0.576-0.192 0.704s-0.064 0.256-0.064 0.288c-0.064 0.064-0.128 0.352-0.16 0.672-0.032 0.064-0.064 0.16-0.064 0.256-0.064 0.16-0.256 0.832-0.288 0.992 0 0.064-0.032 0.192-0.064 0.256-0.064 0.128-0.224 0.8-0.256 0.992-0.032 0.064-0.16 0.576-0.288 1.088-0.16 0.512-0.288 1.024-0.288 1.088-0.032 0.096-0.096 0.288-0.128 0.448-0.064 0.192-0.064 0.352-0.064 0.384 0.032 0.032 0.032 0.096-0.032 0.096-0.096 0.032-0.224 0.96-0.192 1.632 0 0.544 0.32 1.696 0.448 1.696 0.032 0 0.096 0.064 0.128 0.16 0.064 0.224 0.64 0.768 1.024 0.992 0.96 0.544 2.752 0.608 4.512 0.224 0.736-0.16 1.888-0.544 1.92-0.64 0-0.032 0.064-0.064 0.096-0.032 0.064 0.064 1.088-0.448 1.312-0.64 0.064-0.032 0.128-0.064 0.16-0.032 0.032 0-0.032 0.416-0.128 0.864-0.096 0.48-0.16 0.896-0.16 0.928 0 0.064-0.032 0.224-0.16 0.672 0 0.096-0.096 0.16-0.16 0.16-0.576 0-2.688 0.512-2.688 0.608 0 0.064-0.032 0.064-0.096 0.032s-1.184 0.384-1.28 0.512c-0.032 0.032-0.064 0.064-0.064 0s-0.672 0.288-0.768 0.384c0 0.032-0.064 0.096-0.096 0.096-0.16 0-0.704 0.352-0.672 0.416s0.032 0.064-0.032 0.032c-0.16-0.096-1.856 1.664-1.696 1.824 0.032 0.032 0 0.032-0.064 0.032-0.128 0-0.832 1.472-0.96 2.112-0.032 0.096-0.128 0.992-0.16 1.216-0.032 0.544 0.128 1.344 0.384 1.92 0.864 1.824 3.040 2.688 5.44 2.176 0.512-0.128 1.568-0.512 1.696-0.64 0.064-0.064 0.16-0.128 0.16-0.096 0.064 0.032 0.192 0 0.32-0.128 0.096-0.096 0.256-0.224 0.352-0.288 0.192-0.128 0.736-0.64 1.088-1.024 0.32-0.352 0.768-1.024 0.736-1.088-0.032-0.032-0.032-0.064 0.032-0.064s0.352-0.512 0.352-0.608c0-0.032 0.032-0.096 0.064-0.128 0.192-0.128 0.832-1.888 1.088-3.008 0.16-0.64 0.32-1.184 0.352-1.248 0.064-0.16 0.384-0.16 1.984 0.032 0.992 0.128 1.152 0.128 1.344 0.16 0.128 0.032 0.544 0.096 0.96 0.192 1.12 0.16 0.992 0.16 2.88 0.544 0.736 0.128 1.376 0.256 1.472 0.288 0.064 0 0.192 0.032 0.288 0.064 0.064 0.032 0.224 0.064 0.352 0.064 0.192 0.032 0.832 0.16 0.896 0.192 0.032 0 0.16 0.032 0.256 0.064 0.224 0.064 2.432 0.512 2.752 0.608 0.128 0 0.512 0.096 0.864 0.16 0.8 0.16 1.12 0.224 1.376 0.256 0.096 0 0.192 0.032 0.192 0.032 0 0.032 0.064 0.064 0.096 0.064 0.128 0 0.768 0.096 1.024 0.16 0.704 0.128 2.144 0.352 2.528 0.416 0.288 0.032 0.512 0.064 0.544 0.096 0.032 0 0.32 0.032 0.672 0.064 0.32 0.032 0.672 0.064 0.768 0.096 0.704 0.128 5.152 0.224 5.984 0.096 0.224-0.032 0.608-0.064 0.896-0.096s0.544-0.128 0.576-0.16c0.032-0.032 0.064-0.032 0.096-0.032 0.256 0.16 3.616-0.992 3.616-1.216 0-0.032 0.032-0.064 0.064-0.064 0.096 0.032 0.576-0.224 1.024-0.544 0.512-0.384 0.768-0.896 0.768-1.504 0-0.544-0.288-1.248-0.672-1.76-0.288-0.416-0.608-0.736-0.608-0.64 0 0.032-0.032 0-0.096-0.032-0.064-0.064-0.352 0.032-1.056 0.384-0.544 0.256-1.12 0.512-1.28 0.576s-0.416 0.16-0.544 0.224c-0.32 0.16-2.336 0.672-2.816 0.736-0.192 0.032-0.448 0.064-0.544 0.096-0.128 0-0.448 0.032-0.768 0.064-0.288 0.064-0.672 0.096-0.832 0.096-0.448 0.064-3.904 0.064-4.512 0-0.288 0-0.768-0.064-1.056-0.096-0.416-0.032-0.768-0.064-1.664-0.16-0.128 0-0.384-0.032-0.576-0.064-1.152-0.16-1.792-0.256-1.952-0.256-0.128-0.032-0.224-0.032-0.224-0.032 0-0.032-0.16-0.064-0.704-0.128-0.224-0.032-0.48-0.064-0.576-0.096-0.128-0.032-0.448-0.096-0.768-0.128-0.288-0.064-0.64-0.128-0.736-0.128-0.128-0.032-0.32-0.064-0.416-0.064-0.256-0.064-2.048-0.384-2.368-0.448-0.192-0.032-0.736-0.128-1.024-0.16-0.096 0-0.16-0.032-0.16-0.032 0-0.032-0.224-0.064-0.672-0.128-0.192 0-0.416-0.064-0.512-0.064-0.096-0.032-0.32-0.064-0.544-0.096-0.192-0.032-0.448-0.096-0.544-0.096-0.096-0.032-0.32-0.064-0.512-0.064-0.16-0.032-0.384-0.064-0.48-0.064-0.096-0.032-0.416-0.096-0.672-0.128-0.288-0.032-0.576-0.064-0.672-0.064-0.096-0.032-0.384-0.064-0.64-0.096-0.224-0.032-0.544-0.064-0.704-0.064-0.48-0.064-1.568-0.16-1.76-0.16-0.16 0.032-0.16 0-0.064-0.512 0.064-0.288 0.128-0.672 0.16-0.896 0.128-0.768 0.256-1.6 0.32-1.92 0.032-0.096 0.096-0.352 0.096-0.48 0.032-0.16 0.096-0.512 0.128-0.736 0.064-0.224 0.096-0.544 0.128-0.704 0-0.128 0.064-0.32 0.064-0.416 0.032-0.064 0.064-0.288 0.096-0.512 0.032-0.192 0.064-0.416 0.096-0.48 0-0.064 0.032-0.256 0.064-0.416s0.064-0.384 0.096-0.512c0.032-0.192 0.128-0.704 0.16-1.056 0.032-0.128 0.064-0.352 0.16-0.832 0.032-0.096 0.064-0.32 0.096-0.544 0.032-0.192 0.064-0.448 0.096-0.544 0.032-0.224 0.096-0.544 0.16-0.896 0.032-0.128 0.096-0.576 0.16-0.928 0.064-0.384 0.128-0.8 0.16-0.96s0.096-0.576 0.16-0.896c0.096-0.32 0.16-0.768 0.16-0.96 0.032-0.224 0.064-0.416 0.096-0.48 0.032-0.032 0.064-0.224 0.096-0.448 0-0.192 0.064-0.416 0.064-0.48 0.032-0.064 0.064-0.288 0.096-0.48 0-0.192 0.032-0.384 0.064-0.416 0.096-0.128 0.16-1.152 0.096-1.536-0.032-0.224-0.128-0.48-0.192-0.544-0.096-0.096-0.16-0.192-0.128-0.224 0.032 0-0.128-0.128-0.32-0.224-0.672-0.352-2.176-0.288-2.912 0.128-0.256 0.16-0.288 0.192-0.256 0.512 0.064 0.832 0.032 1.728-0.096 2.496-0.096 0.448-0.16 0.896-0.192 0.96 0 0.064-0.032 0.288-0.064 0.448-0.032 0.192-0.096 0.416-0.096 0.512-0.032 0.096-0.064 0.256-0.064 0.384-0.032 0.096-0.064 0.32-0.096 0.48s-0.128 0.8-0.256 1.376c-0.096 0.608-0.224 1.248-0.224 1.408-0.032 0.16-0.096 0.48-0.16 0.736-0.032 0.256-0.096 0.544-0.128 0.672 0 0.128-0.032 0.352-0.064 0.512s-0.16 0.768-0.256 1.376c-0.128 0.608-0.192 1.152-0.192 1.184 0 0.096-0.768 0.544-1.312 0.736-0.192 0.064-0.384 0.16-0.384 0.224s0 0.064-0.032 0.032-0.352 0.064-0.736 0.192c-1.632 0.544-3.008 0.608-3.488 0.128-0.192-0.192-0.192-0.256-0.192-0.928 0-0.736 0.032-0.896 0.992-4.448 0.064-0.256 0.096-0.512 0.064-0.512 0-0.032 0.032-0.096 0.064-0.096 0.032-0.032 0.096-0.16 0.128-0.288 0-0.128 0.032-0.256 0.032-0.256 0.032 0 0.064-0.128 0.128-0.48 0.096-0.48 0.096-0.512 0.128-0.544 0 0 0.032-0.032 0.032-0.064s0.064-0.224 0.128-0.448c0.064-0.192 0.128-0.448 0.128-0.544s0.032-0.224 0.064-0.288c0.48-1.344 0.48-3.2 0-4.256-0.352-0.8-1.216-1.408-2.208-1.6-0.416-0.064-1.696-0.096-1.76-0.032zM10.944 23.968c-0.032 0.192-0.128 0.416-0.16 0.544s-0.064 0.256-0.064 0.288c0 0.064 0 0.096-0.352 0.96-0.128 0.288-0.224 0.576-0.192 0.576 0.032 0.032 0 0.064-0.064 0.064s-0.224 0.32-0.192 0.448c0 0.032 0 0.032-0.032 0.032-0.064-0.032-0.16 0.064-0.224 0.224-0.192 0.288-0.608 0.704-0.832 0.768-0.064 0.032-0.128 0.064-0.128 0.096 0 0.096-0.064 0.096-0.704 0.128-0.544 0.032-0.736-0.064-0.96-0.512-0.16-0.224-0.128-0.992 0.032-1.408 0.064-0.16 0.128-0.352 0.128-0.416s0.032-0.096 0.064-0.064c0.064 0.032 0.096-0.032 0.128-0.128 0.064-0.192 0.832-0.928 0.992-0.928 0.032 0 0.032-0.032 0-0.064-0.032-0.064 0-0.096 0.032-0.096 0.096 0.064 0.704-0.256 0.8-0.384 0.032-0.032 0.064-0.032 0.064 0s0.064 0 0.16-0.032c0.16-0.096 1.28-0.416 1.472-0.416 0.064 0 0.064 0.096 0.032 0.32zM38.848 5.952c-0.16 0.032-0.384 0.064-0.512 0.096-0.288 0.064-1.44 0.48-1.504 0.576-0.032 0.064-0.064 0.064-0.064 0.032s-0.16 0.032-0.352 0.096c-0.32 0.192-0.576 0.224-0.544 0.128 0-0.128-0.128-0.352-0.256-0.352-0.064 0-0.096-0.032-0.096-0.064 0-0.16-0.608-0.352-1.312-0.384-0.48-0.064-2.048 0.384-1.92 0.512 0.032 0 0 0.096-0.032 0.128-0.064 0.096-0.064 0.224 0 0.448 0.096 0.416 0.096 1.248 0 1.632-0.064 0.16-0.096 0.416-0.128 0.64s-0.032 0.384-0.032 0.384c-0.032 0-0.064 0.16-0.128 0.576-0.032 0.16-0.064 0.384-0.096 0.48-0.032 0.128-0.064 0.32-0.064 0.48-0.032 0.16-0.064 0.384-0.096 0.512-0.064 0.224-0.448 2.496-0.512 2.816-0.032 0.256-0.096 0.576-0.192 1.184-0.064 0.256-0.128 0.608-0.128 0.768-0.032 0.128-0.064 0.384-0.096 0.48-0.288 1.6 0.032 2.368 1.056 2.592 0.48 0.128 1.728 0.032 1.888-0.096 0.032-0.032 0.128-0.064 0.224-0.064 0.064 0 0.128-0.032 0.128-0.096 0-0.032 0.032-0.064 0.064-0.064 0.352 0.064 0.448-0.224 0.32-0.8-0.128-0.544-0.096-0.896 0.096-1.856 0.064-0.416 0.16-0.864 0.16-0.992 0.032-0.128 0.064-0.352 0.096-0.448 0.096-0.544 0.128-0.64 0.16-0.896 0.032-0.128 0.064-0.352 0.064-0.48 0.032-0.16 0.064-0.384 0.096-0.512 0.224-1.152 0.288-1.568 0.256-1.632-0.032-0.032-0.032-0.096 0.032-0.128 0.032 0 0.064-0.128 0.064-0.256s0.064-0.48 0.128-0.736l0.096-0.512 0.576-0.256c0.64-0.32 0.992-0.416 1.44-0.32 0.544 0.096 0.704 0.704 0.512 1.824-0.032 0.192-0.096 0.416-0.096 0.512-0.032 0.096-0.064 0.256-0.064 0.384-0.032 0.096-0.064 0.32-0.096 0.48s-0.096 0.608-0.16 1.024c-0.064 0.384-0.16 0.832-0.16 1.024-0.032 0.16-0.064 0.32-0.096 0.384-0.032 0.032-0.064 0.224-0.096 0.48 0 0.224-0.064 0.48-0.096 0.608-0.224 1.152-0.288 2.112-0.16 2.56 0.128 0.32 0.608 0.8 0.736 0.768 0.064-0.032 0.192 0 0.32 0.064 0.256 0.16 1.376 0.096 1.984-0.096 0.576-0.16 0.8-0.384 0.736-0.672-0.032-0.128-0.096-0.32-0.096-0.448-0.032-0.128-0.064-0.256-0.064-0.288-0.032-0.064 0.032-0.512 0.128-1.024 0.064-0.512 0.16-1.056 0.192-1.216s0.096-0.448 0.128-0.704c0.096-0.448 0.16-0.896 0.192-1.152 0.032-0.096 0.096-0.544 0.16-0.96 0.096-0.448 0.16-0.896 0.192-0.992 0-0.128 0.064-0.352 0.064-0.512 0.032-0.16 0.128-0.544 0.16-0.864l0.096-0.576 0.544-0.288c0.768-0.384 1.344-0.48 1.664-0.288 0.16 0.096 0.32 0.288 0.352 0.416 0.096 0.256 0.032 1.088-0.128 1.984-0.064 0.288-0.096 0.448-0.288 1.664-0.224 1.312-0.256 1.472-0.32 1.792 0 0.16-0.032 0.352-0.064 0.416 0 0.064-0.064 0.256-0.064 0.384-0.032 0.16-0.096 0.416-0.096 0.544-0.224 1.216-0.224 1.76 0 2.24 0.128 0.224 0.288 0.352 0.576 0.512 0.384 0.192 0.512 0.192 1.216 0.192 0.608 0 0.896-0.032 1.28-0.192 0.608-0.224 0.672-0.352 0.544-0.928-0.096-0.512-0.032-1.408 0.192-2.464 0.032-0.224 0.096-0.576 0.128-0.736 0.032-0.192 0.096-0.608 0.16-0.928 0.064-0.288 0.096-0.576 0.096-0.608s0-0.064 0.032-0.096c0.032-0.096 0.064-0.288 0.096-0.672 0.032-0.224 0.096-0.448 0.096-0.512 0.032-0.064 0.064-0.256 0.096-0.416 0-0.16 0.064-0.384 0.064-0.448 0.032-0.128 0.064-0.32 0.096-0.48s0.064-0.352 0.064-0.448c0.224-1.088 0.32-2.272 0.192-2.848-0.096-0.512-0.128-0.576-0.256-0.832-0.416-0.8-1.12-1.184-2.432-1.248-0.608-0.032-2.464 0.448-2.464 0.64 0 0.064 0 0.064-0.032 0.032s-0.384 0.128-0.736 0.32l-0.704 0.352-0.16-0.224c-0.224-0.416-0.608-0.736-1.088-0.896-0.48-0.192-1.504-0.288-1.952-0.16zM21.536 6.048c0 0.032-0.224 0.064-0.48 0.064-0.544 0.064-1.184 0.224-1.184 0.352 0 0.032-0.032 0.032-0.064 0.032-0.032-0.032-0.128 0-0.224 0.096-0.128 0.16-0.128 0.192 0.032 0.832 0.064 0.224 0.032 0.864-0.064 1.376-0.064 0.288-0.128 0.608-0.128 0.768 0 0.128-0.064 0.416-0.128 0.64-0.032 0.224-0.096 0.544-0.128 0.704-0.064 0.544-0.096 0.704-0.16 0.864 0 0.064-0.064 0.32-0.064 0.544-0.032 0.224-0.064 0.416-0.096 0.448 0 0.032-0.064 0.224-0.096 0.48-0.032 0.224-0.064 0.48-0.064 0.544-0.032 0.064-0.064 0.256-0.096 0.416-0.096 0.544-0.128 0.8-0.16 1.024-0.16 0.896-0.096 2.208 0.096 2.624 0.064 0.096 0.128 0.256 0.192 0.384 0.16 0.352 0.704 0.896 1.056 1.024 0.928 0.384 1.664 0.416 2.784 0.128 0.224-0.064 0.416-0.128 0.448-0.128 0.064 0 0.16-0.064 0.256-0.096 0.704-0.288 1.472-0.544 1.504-0.512 0 0 0.064 0.128 0.128 0.256 0.288 0.608 0.896 0.864 1.888 0.864 0.64-0.032 1.536-0.256 1.632-0.416 0.032-0.032 0.096-0.064 0.128-0.096 0.032 0 0.064-0.16 0.064-0.384-0.096-1.248-0.096-1.472-0.032-1.76 0.032-0.16 0.096-0.416 0.128-0.576 0.064-0.576 0.128-0.96 0.16-1.12 0.032-0.096 0.064-0.288 0.096-0.448s0.064-0.384 0.096-0.48c0-0.096 0.032-0.288 0.064-0.448s0.096-0.576 0.16-0.896c0.064-0.288 0.128-0.576 0.096-0.608s0-0.096 0.032-0.16c0.032-0.096 0.096-0.32 0.128-0.512 0.032-0.224 0.064-0.48 0.096-0.608 0.032-0.192 0.32-1.792 0.416-2.272 0-0.16 0.064-0.352 0.064-0.48 0.128-0.448 0.064-1.312-0.096-1.632-0.128-0.288-0.736-0.768-0.832-0.672-0.032 0.032-0.096 0-0.16-0.032-0.096-0.096-1.088-0.128-1.44-0.032-0.448 0.096-1.056 0.32-1.184 0.416-0.096 0.096-0.096 0.192-0.032 0.544 0.096 0.448 0.096 1.312 0 1.824-0.032 0.16-0.128 0.576-0.192 0.928-0.064 0.32-0.096 0.64-0.096 0.64 0 0.032 0 0.096 0 0.128-0.032 0.064-0.096 0.352-0.128 0.576-0.032 0.192-0.128 0.704-0.192 1.024-0.032 0.096-0.064 0.32-0.064 0.48-0.032 0.16-0.064 0.32-0.064 0.384-0.032 0.032-0.064 0.256-0.096 0.48-0.064 0.224-0.096 0.448-0.096 0.48 0 0-0.064 0.32-0.128 0.704-0.096 0.576-0.128 0.64-0.352 0.736-0.128 0.064-0.224 0.128-0.192 0.128 0.032 0.032-0.032 0.064-0.096 0.064-0.096 0-0.32 0.064-0.512 0.16-0.864 0.32-1.856 0.064-1.92-0.512 0-0.096-0.032-0.224-0.032-0.288 0-0.16 0.16-1.472 0.192-1.472 0 0 0.032-0.064 0.032-0.16s0.032-0.288 0.064-0.416c0.032-0.128 0.096-0.384 0.096-0.512 0.128-0.704 0.192-1.152 0.256-1.44 0.032-0.128 0.064-0.384 0.096-0.544 0.032-0.192 0.128-0.8 0.256-1.344 0.288-1.632 0.16-2.432-0.416-2.784-0.16-0.064-0.288-0.16-0.352-0.16-0.512-0.096-0.864-0.16-0.896-0.16z' ],
			'width'  => 49,
			'height' => 32,
			'pro'    => true,
		],
		'buffer'     => [
			'paths'  => [ 'M0 24.384q0.352-0.48 1.024-0.832t1.568-0.64 1.28-0.48q0.608 0 1.088 0.128t1.056 0.48 0.8 0.416q1.504 0.672 8.32 3.808 0.608 0.128 1.152 0t1.248-0.576 0.768-0.448q0.64-0.288 2.464-1.12t2.784-1.248q0.128-0.064 1.344-0.672t1.92-0.768q0.416-0.064 0.896 0.032t0.736 0.224 0.736 0.416 0.576 0.352 0.512 0.192 0.576 0.256 0.352 0.352q0.096 0.128 0.128 0.448-0.32 0.416-0.992 0.768t-1.632 0.704-1.28 0.512q-1.376 0.64-4.096 1.984t-4.128 1.952q-0.224 0.096-0.672 0.384t-0.736 0.416-0.832 0.352-0.864 0.224-0.96-0.064l-8.448-3.936q-0.192-0.096-1.024-0.448t-1.632-0.704-1.728-0.768-1.472-0.768-0.704-0.512q-0.128-0.128-0.128-0.416zM0 15.808q0.352-0.48 1.024-0.8t1.6-0.64 1.312-0.48q0.608 0 1.088 0.128t1.12 0.48 0.8 0.448q1.344 0.608 4.064 1.856t4.064 1.888q0.608 0.16 1.184 0t1.248-0.544 0.8-0.448q2.176-1.024 5.12-2.304 0.352-0.16 1.024-0.544t1.216-0.608 1.152-0.352q0.512-0.096 1.024 0.032t1.184 0.544 0.736 0.416q0.16 0.096 0.512 0.192t0.576 0.256 0.352 0.352q0.096 0.16 0.128 0.448-0.32 0.448-0.992 0.8t-1.696 0.736-1.312 0.512q-1.536 0.736-4.32 2.080t-3.936 1.888q-0.224 0.096-0.832 0.448t-0.928 0.48-1.024 0.32-1.152 0q-6.848-3.232-8.32-3.904-0.192-0.096-1.408-0.608t-2.208-0.96-1.984-0.96-1.088-0.704q-0.128-0.128-0.128-0.448zM0 7.264q0.32-0.48 1.024-0.864t1.664-0.704 1.312-0.512l11.136-5.184q0.96 0 1.728 0.224t1.792 0.832 1.28 0.704q1.248 0.576 3.744 1.728t3.744 1.76q0.128 0.064 1.184 0.48t1.728 0.768 0.864 0.64q0.096 0.128 0.128 0.416-0.288 0.416-0.832 0.704t-1.376 0.608-1.12 0.448q-1.504 0.704-4.48 2.112t-4.448 2.144q-0.192 0.096-0.64 0.352t-0.736 0.384-0.8 0.352-0.864 0.192-0.896-0.032q-7.84-3.648-8.192-3.808-0.128-0.064-2.016-0.896t-3.264-1.472-1.536-0.96q-0.128-0.128-0.128-0.416z' ],
			'width'  => 31,
			'height' => 32,
			'pro'    => true,
		],
		'tumblr'     => [
			'paths'  => [ 'M16.864 23.744l1.408 4.224q-0.384 0.608-1.952 1.184t-3.168 0.576q-1.856 0.032-3.424-0.48t-2.528-1.312-1.696-1.888-0.992-2.144-0.288-2.112v-9.728h-3.008v-3.84q1.28-0.448 2.304-1.248t1.632-1.6 1.024-1.824 0.608-1.76 0.256-1.568q0.032-0.096 0.096-0.16t0.128-0.064h4.352v7.584h5.952v4.48h-5.952v9.248q0 0.544 0.096 0.992t0.416 0.96 0.896 0.736 1.44 0.256q1.408-0.032 2.4-0.512z' ],
			'width'  => 18,
			'height' => 32,
			'pro'    => true,
		],
		'xing'       => [
			'paths'  => [ 'M0 22.336h7.008l5.536-9.152-4.16-7.328h-7.008l4.16 7.328zM11.584 19.456l11.072-19.456h7.424l-11.040 19.456 7.104 12.544h-7.424z' ],
			'width'  => 30,
			'height' => 32,
			'pro'    => true,
		],
		'flipboard'  => [
			'paths'  => [ 'M0 0h10.272v32h-10.272v-32zM11.328 11.328h10.4v10.4h-10.4v-10.4zM11.328 0h20.672v10.272h-20.672v-10.272z' ],
			'width'  => 32,
			'height' => 32,
			'pro'    => true,
		],
		'telegram'   => [
			'paths'  => [ 'M12.192 27.296c-0.896 0-0.736-0.352-1.056-1.216l-2.688-8.832 20.672-12.288M12.192 27.296c0.704 0 1.024-0.32 1.408-0.704l3.776-3.648-4.704-2.848M12.672 20.096l11.36 8.416c1.312 0.704 2.24 0.352 2.56-1.216l4.64-21.792c0.48-1.888-0.736-2.752-1.952-2.208l-27.168 10.496c-1.856 0.736-1.856 1.76-0.352 2.24l6.976 2.176 16.128-10.176c0.768-0.48 1.472-0.224 0.896 0.288' ],
			'width'  => 32,
			'height' => 32,
			'pro'    => true,
		],
		'mix'        => [
			'paths'  => [ 'M0 4v21.792c0 3.52 5.504 3.648 5.504 0v-14.912c0.48-3.296 5.504-3.136 5.504 0.416v10.944c0 3.648 5.984 3.648 5.984 0v-7.232c0.352-3.424 5.504-3.296 5.504 0.256v1.504c0 3.744 5.504 3.52 5.504 0v-12.768h-28z' ],
			'width'  => 28,
			'height' => 32,
			'pro'    => true,
		],
		'instagram'  => [
			'paths'  => [ 'M18.272 16q0-1.888-1.312-3.232t-3.232-1.344-3.232 1.344-1.344 3.232 1.344 3.232 3.232 1.344 3.232-1.344 1.312-3.232zM20.736 16q0 2.912-2.048 4.992t-4.96 2.048-4.992-2.048-2.048-4.992 2.048-4.992 4.992-2.048 4.96 2.048 2.048 4.992zM22.688 8.672q0 0.672-0.48 1.152t-1.184 0.48-1.152-0.48-0.48-1.152 0.48-1.152 1.152-0.48 1.184 0.48 0.48 1.152zM13.728 4.736q-0.128 0-1.376 0t-1.888 0-1.728 0.064-1.824 0.16-1.28 0.352q-0.896 0.352-1.568 1.024t-1.056 1.568q-0.192 0.512-0.32 1.28t-0.192 1.856-0.032 1.696 0 1.888 0 1.376 0 1.376 0 1.888 0.032 1.696 0.192 1.856 0.32 1.28q0.384 0.896 1.056 1.568t1.568 1.024q0.512 0.192 1.28 0.352t1.824 0.16 1.728 0.064 1.888 0 1.376 0 1.344 0 1.888 0 1.728-0.064 1.856-0.16 1.248-0.352q0.896-0.352 1.6-1.024t1.024-1.568q0.192-0.512 0.32-1.28t0.192-1.856 0.032-1.696 0-1.888 0-1.376 0-1.376 0-1.888-0.032-1.696-0.192-1.856-0.32-1.28q-0.352-0.896-1.024-1.568t-1.6-1.024q-0.512-0.192-1.248-0.352t-1.856-0.16-1.728-0.064-1.888 0-1.344 0zM27.424 16q0 4.096-0.096 5.664-0.16 3.712-2.208 5.76t-5.728 2.208q-1.6 0.096-5.664 0.096t-5.664-0.096q-3.712-0.192-5.76-2.208t-2.208-5.76q-0.096-1.568-0.096-5.664t0.096-5.664q0.16-3.712 2.208-5.76t5.76-2.208q1.568-0.096 5.664-0.096t5.664 0.096q3.712 0.192 5.728 2.208t2.208 5.76q0.096 1.568 0.096 5.664z' ],
			'width'  => 27,
			'height' => 32,
			'pro'    => true,
		],
		'youtube'    => [
			'paths'  => [ 'M12.704 20.128l8.64-4.448-8.64-4.512v8.96zM16 4.736q3.008 0 5.792 0.096t4.096 0.16l1.312 0.064q0 0 0.288 0.032t0.416 0.064 0.416 0.064 0.512 0.16 0.512 0.224 0.544 0.352 0.512 0.48q0.128 0.096 0.288 0.32t0.512 1.056 0.48 1.792q0.128 1.152 0.224 2.432t0.096 2.048v3.136q0.032 2.592-0.32 5.184-0.128 0.96-0.448 1.76t-0.576 1.12l-0.256 0.288q-0.224 0.256-0.512 0.48t-0.544 0.32-0.512 0.224-0.512 0.16-0.416 0.064-0.416 0.064-0.288 0.032q-4.48 0.352-11.2 0.352-3.68-0.064-6.432-0.128t-3.552-0.128l-0.896-0.096-0.64-0.064q-0.64-0.096-0.96-0.16t-0.928-0.384-0.992-0.736q-0.128-0.096-0.288-0.32t-0.512-1.056-0.48-1.792q-0.128-1.152-0.224-2.432t-0.096-2.048v-3.136q-0.032-2.592 0.32-5.184 0.128-0.992 0.448-1.76t0.576-1.12l0.256-0.288q0.256-0.288 0.512-0.48t0.544-0.352 0.512-0.224 0.512-0.16 0.416-0.064 0.416-0.064 0.288-0.032q4.48-0.32 11.2-0.32z' ],
			'width'  => 32,
			'height' => 32,
			'pro'    => true,
		],
		'vimeo'      => [
			'paths'  => [ 'M28.672 9.344q-1.024 5.952-5.472 11.232t-7.84 7.584q-1.344 0.896-2.592 0.544t-2.112-1.216-1.376-1.952q-0.512-1.024-2.496-7.648t-2.368-7.136q-0.512-0.384-1.216-0.16t-1.408 0.672l-0.64 0.448-1.152-1.6q0.576-0.64 1.472-1.664t3.2-2.848 3.968-2.144q0.96-0.192 1.696 0.224t1.152 1.12 0.736 1.92 0.48 2.24 0.384 2.4 0.416 2.144q0.448 1.728 0.672 2.56t0.544 1.728 0.576 1.248 0.576 0.352q1.28 0 4.032-5.312 1.344-2.432 0.192-3.968t-3.584-0.064q0.704-4.032 4.48-6.016 3.328-1.728 5.824-0.256 2.56 1.472 1.856 5.568z' ],
			'width'  => 29,
			'height' => 32,
			'pro'    => true,
		],
		'soundcloud' => [
			'paths'  => [ 'M0 20.128q0-0.512 0.128-1.408t0.288-0.992q0.192 0.096 0.352 1.024t0.128 1.376q0 0.448-0.128 1.344t-0.352 1.024q-0.416-0.224-0.416-2.368zM2.048 20.128q0-0.8 0.16-2.368t0.192-1.952q0-0.192 0.192-0.192 0.128 0 0.192 0.192 0.384 4.128 0.384 4.32 0 0.768-0.16 2.272t-0.224 1.888q-0.064 0.224-0.192 0.224-0.192 0-0.192-0.224-0.032-0.352-0.192-1.888t-0.16-2.272zM4.64 20.128q0-0.768 0.16-2.368t0.16-1.728q0-0.288 0.224-0.288 0.256 0 0.256 0.288 0.352 3.616 0.352 4.096t-0.352 4.352q0 0.256-0.256 0.256-0.224 0-0.224-0.256 0-0.224-0.16-1.888t-0.16-2.464zM7.584 20.128q0-1.216 0.064-2.592t0.128-3.040 0.096-2.592q0-0.32 0.288-0.32 0.32 0 0.32 0.32 0.032 0.512 0.192 3.552t0.128 4.672q0 0.832-0.16 2.464t-0.16 1.856q0 0.32-0.32 0.32-0.288 0-0.288-0.32-0.288-4.224-0.288-4.32zM10.592 20.128q0-1.76 0.096-5.12t0.128-4.096q0.064-0.384 0.384-0.384t0.384 0.384q0.032 1.024 0.16 4.256t0.096 4.96q0 0.8-0.096 2.304t-0.16 1.952q-0.064 0.384-0.384 0.384t-0.384-0.384q0-0.352-0.096-1.888t-0.128-2.368zM13.632 20.128q0-1.28 0.032-2.72t0.096-3.2 0.064-2.72q0.064-0.48 0.448-0.48t0.448 0.48q0.032 0.96 0.096 2.72t0.064 3.2 0.032 2.72q0 0.064-0.192 4.192v-0.032q-0.064 0.48-0.448 0.48t-0.448-0.448q-0.192-4.128-0.192-4.192zM16.672 20.16q0-0.096 0.192-11.232 0.064-0.576 0.512-0.576t0.512 0.576q0.192 11.136 0.192 11.232 0 0.032-0.192 4.064-0.064 0.544-0.512 0.544t-0.512-0.544q-0.192-4.032-0.192-4.064zM19.232 13.344q0-2.624 0.032-4.96-0.032-0.32 0.416-0.576t1.024-0.384 1.12-0.16 0.768-0.064q3.104 0 5.408 2.304t2.56 5.728q0.896-0.416 1.76-0.416 1.856 0 3.2 1.44t1.344 3.552-1.344 3.52-3.2 1.472h-12.576q-0.192 0-0.32-0.192t-0.16-0.416q0-1.76 0-4.992t-0.032-5.856z' ],
			'width'  => 37,
			'height' => 32,
			'pro'    => true,
		],
		'twitch'     => [
			'paths'  => [ 'M16 7.744v7.744h-2.592v-7.744h2.592zM23.104 7.744v7.744h-2.592v-7.744h2.592zM23.104 21.312l4.512-4.512v-14.208h-21.312v18.72h5.824v3.872l3.872-3.872h7.104zM30.208 0v18.080l-7.744 7.744h-5.824l-3.872 3.904h-3.872v-3.904h-7.104v-20.672l1.952-5.152h26.464z' ],
			'width'  => 32,
			'height' => 32,
			'pro'    => true,
		],
		'behance'    => [
			'paths'  => [ 'M32.992 6.048h-9.12v2.208h9.12v-2.208zM28.512 13.664q-1.632 0-2.624 0.928t-1.088 2.56h7.264q-0.32-3.488-3.552-3.488zM28.8 24.096q1.12 0 2.176-0.576t1.344-1.536h3.936q-1.76 5.472-7.616 5.472-3.808 0-6.080-2.336t-2.24-6.208q0-3.712 2.304-6.176t6.016-2.464q2.464 0 4.288 1.216t2.752 3.2 0.896 4.448q0 0.288-0.032 0.832h-11.744q0 1.984 1.024 3.072t2.976 1.056zM4.96 23.2h5.28q3.648 0 3.648-2.976 0-3.2-3.552-3.2h-5.376v6.176zM4.96 13.632h4.992q1.408 0 2.208-0.672t0.832-2.016q0-2.56-3.392-2.56h-4.64v5.248zM0 4.544h10.624q1.536 0 2.752 0.256t2.272 0.832 1.6 1.728 0.544 2.752q0 3.232-3.072 4.704 2.048 0.544 3.072 2.048t1.056 3.648q0 1.312-0.448 2.432t-1.184 1.856-1.76 1.248-2.144 0.768-2.4 0.224h-10.912v-22.496z' ],
			'width'  => 37,
			'height' => 32,
			'pro'    => true,
		],
		'github'     => [
			'paths'  => [ 'M0 15.968q0-3.264 1.28-6.208 2.528-5.952 8.48-8.48 2.944-1.28 6.208-1.28t6.208 1.28q5.888 2.496 8.48 8.48 1.28 3.040 1.28 6.208t-1.28 6.208q-2.592 6.016-8.48 8.544-2.944 1.28-6.208 1.28t-6.208-1.28q-5.952-2.56-8.48-8.544-1.28-2.944-1.28-6.208zM2.496 15.968q0 4.512 2.688 8.064 2.656 3.488 6.944 4.96v-2.56q0-1.92 1.28-2.784-0.64-0.032-1.504-0.224-1.632-0.288-2.784-1.024-2.912-1.76-2.912-6.368 0-2.4 1.6-4.096-0.736-1.888 0.16-4.096h0.64q0.32 0 0.8 0.16 1.248 0.384 2.784 1.408 1.952-0.512 3.84-0.512t3.872 0.512q1.248-0.832 2.336-1.28 1.024-0.384 1.472-0.32l0.384 0.032q0.864 2.208 0.16 4.096 1.6 1.696 1.6 4.096 0 3.584-1.76 5.408-0.96 1.024-2.528 1.6-1.312 0.48-2.912 0.608 1.312 0.928 1.312 2.784v2.56q4.128-1.472 6.816-5.024 2.624-3.52 2.624-8 0-2.72-1.056-5.248-1.024-2.432-2.88-4.288-1.792-1.792-4.288-2.848-2.56-1.088-5.216-1.088-2.624 0-5.248 1.088-2.4 1.024-4.288 2.848-1.792 1.856-2.88 4.288-1.056 2.528-1.056 5.248z' ],
			'width'  => 32,
			'height' => 32,
			'pro'    => true,
		],
		'medium'     => [
			'paths'  => [ 'M4.48 8.896c0.032-0.384-0.128-0.736-0.384-0.992l-2.816-3.392v-0.512h8.768l6.752 14.848 5.952-14.848h8.384v0.512l-2.432 2.304c-0.192 0.16-0.32 0.416-0.256 0.672v16.992c-0.064 0.256 0.064 0.544 0.256 0.672l2.368 2.336v0.512h-11.872v-0.512l2.464-2.368c0.224-0.256 0.224-0.32 0.224-0.672v-13.76l-6.784 17.248h-0.928l-7.904-17.248v11.552c-0.064 0.512 0.096 0.992 0.448 1.344l3.168 3.84v0.512h-8.992v-0.512l3.168-3.84c0.352-0.352 0.48-0.864 0.416-1.344v-13.344z' ],
			'width'  => 32,
			'height' => 32,
			'pro'    => true,
		],
		'grow'       => [
			'paths'  => [
				'M 40.0625 12.7344 C 40.0625 14.4219 40.0625 16.1094 40.0391 17.8086 C 39.9922 17.8711 39.9453 17.9219 39.9375 17.9766 C 39.8906 18.3164 39.875 18.6641 39.8047 19 C 39.4766 20.5898 39.0273 22.1406 38.2422 23.5781 C 37.6953 24.5781 37.043 25.4961 36.2617 26.3086 C 35.7773 26.8125 35.2383 27.2695 34.6914 27.7031 C 33.2227 28.8633 31.582 29.7227 29.8242 30.3281 C 28.6953 30.7148 27.5469 31.0586 26.3906 31.3438 C 25.5273 31.5625 24.6328 31.6836 23.7461 31.8008 C 23.0938 31.8867 22.4336 31.8906 21.7773 31.9414 C 21.7227 31.9453 21.6719 32.0195 21.6211 32.0625 C 21.1133 32.0625 20.6016 32.0625 20.082 32.043 C 19.8477 31.332 19.5703 30.6484 19.4063 29.9414 C 19.1328 28.7578 18.9023 27.5586 18.7031 26.3594 C 18.5742 25.5781 18.4766 24.7852 18.4531 23.9922 C 18.4258 22.9453 18.4648 21.8945 18.5117 20.8438 C 18.5391 20.2305 18.5703 19.6016 18.7109 19.0078 C 18.957 17.9609 19.2344 16.9141 19.5977 15.9063 C 20.1523 14.375 21 13.0039 22.125 11.8281 C 22.6602 11.2695 23.25 10.7617 23.8516 10.2773 C 25.0469 9.32031 26.3828 8.59766 27.7852 8.01172 C 29.0547 7.47656 30.3594 7.01953 31.7188 6.76563 C 33.043 6.51953 34.3672 6.27344 35.7031 6.09375 C 36.4063 5.99609 37.1328 6.03125 37.8477 6.01953 C 38.4727 6.00781 38.4883 6.01172 38.6602 6.62891 C 38.9922 7.80469 39.3359 8.98047 39.6016 10.168 C 39.7813 10.957 39.8281 11.7734 39.9414 12.5781 C 39.9492 12.6367 40.0195 12.6836 40.0625 12.7344 Z M 40.0625 12.7344',
				'M 20.2617 0.0625 C 20.3633 0.152344 20.4258 0.257812 20.5195 0.324219 C 21.9844 1.36328 23.3203 2.55469 24.5352 3.875 C 25.2422 4.64063 25.8789 5.46875 26.5469 6.26953 C 26.5977 6.33203 26.6172 6.41406 26.6563 6.49609 C 25.4414 7.03125 24.293 7.66406 23.2383 8.44922 C 22.6992 8.85156 22.1719 9.27734 21.668 9.72266 C 20.6875 10.5859 19.8516 11.582 19.1563 12.6914 C 18.3164 14.0273 17.6719 15.457 17.3008 16.9961 C 17.0859 17.8984 16.8984 18.8086 16.7344 19.7188 C 16.6484 20.2148 16.6367 20.7227 16.5977 21.2227 C 16.5703 21.6445 16.5273 22.0664 16.5391 22.4883 C 16.5586 23.1914 16.6133 23.8945 16.6602 24.5977 C 16.6953 25.1016 16.7266 25.6016 16.793 26.1016 C 16.8906 26.8516 17.0078 27.6016 17.1367 28.3477 C 17.2266 28.8594 17.3516 29.3672 17.4805 29.9727 C 16.918 29.4297 16.4063 28.9531 15.9141 28.4531 C 15.6016 28.1328 15.3203 27.7734 15.0234 27.4375 C 14.0898 26.3945 13.25 25.2773 12.5313 24.0703 C 11.7539 22.7656 11.0625 21.4102 10.6758 19.9258 C 10.4688 19.1211 10.3203 18.2969 10.1836 17.4727 C 10.1016 16.9883 10.0313 16.4883 10.0586 16.0039 C 10.1055 15.1719 10.1953 14.3359 10.3359 13.5156 C 10.5664 12.1406 11.0469 10.8359 11.6836 9.60156 C 12.1758 8.64844 12.7461 7.72266 13.3555 6.83594 C 13.9023 6.04297 14.5195 5.29297 15.1563 4.57031 C 15.8359 3.79688 16.5391 3.03906 17.3008 2.35547 C 18.1289 1.60938 19.0391 0.953125 19.9141 0.253906 C 19.9727 0.210938 20.0156 0.152344 20.0508 0.0820312 C 20.1016 0.0625 20.168 0.0625 20.2617 0.0625 Z M 20.2617 0.0625',
				'M 0.0625 14.75 C 0.105469 14.668 0.183594 14.6172 0.183594 14.5625 C 0.214844 14.0156 0.210938 13.4609 0.261719 12.9141 C 0.320312 12.2305 0.394531 11.5469 0.519531 10.8711 C 0.675781 10.0078 0.867188 9.15234 1.08594 8.30469 C 1.28516 7.54297 1.54297 6.79297 1.78906 6.04297 C 1.80859 5.97266 1.93359 5.89063 2.01172 5.89453 C 2.85938 5.92578 3.71094 5.9375 4.55469 6.02344 C 5.60938 6.13672 6.66797 6.27344 7.71094 6.47656 C 8.62109 6.65625 9.51172 6.94531 10.4063 7.1875 C 10.543 7.22266 10.6758 7.26953 10.8203 7.31641 C 10.5352 7.84766 10.2422 8.35547 9.98828 8.88281 C 9.27344 10.3672 8.69141 11.9023 8.46484 13.5508 C 8.34375 14.418 8.21484 15.2969 8.21875 16.1719 C 8.22656 17.5547 8.44531 18.9219 8.83594 20.2578 C 9.19141 21.4609 9.65625 22.6211 10.2383 23.7305 C 10.9141 25.0117 11.7031 26.2148 12.582 27.3633 C 13.6094 28.707 14.7891 29.9063 15.9844 31.0898 C 16.2188 31.3242 16.4766 31.5352 16.793 31.8164 C 16.3203 31.7617 15.9414 31.7461 15.5742 31.6719 C 14.6875 31.4961 13.8047 31.3203 12.9297 31.0977 C 11.6641 30.7773 10.4258 30.3594 9.23047 29.8281 C 8.13672 29.3477 7.09766 28.7813 6.12109 28.0977 C 4.99219 27.3086 4.01172 26.3633 3.14453 25.2852 C 2.11719 24.0078 1.39453 22.5742 0.949219 21.0078 C 0.671875 20.0273 0.515625 19.0156 0.320312 18.0117 C 0.210938 17.4414 0.171875 16.8633 0.1875 16.2852 C 0.1875 16.2188 0.136719 16.1523 0.0859375 16.1094 C 0.0625 15.6797 0.0625 15.2305 0.0625 14.75 Z M 0.0625 14.75',
			],
			'width'  => 40,
			'height' => 32,
			'pro'    => true,
		],
		'grow-heart' => [
			'paths'  => [ 'M7 12.04L6.13 11.2464C3.04 8.43681 1 6.57715 1 4.30899C1 2.45054 2.452 1 4.3 1C5.344 1 6.346 1.48732 7 2.2514C7.654 1.48732 8.656 1 9.7 1C11.548 1 13 2.45054 13 4.30899C13 6.57715 10.96 8.43681 7.87 11.2464L7 12.04Z' ],
			'width'  => 14,
			'height' => 14,
			'pro'    => true,
		],
		'threads'     => [
			'paths'  => [ 'M6.321 6.016c-.27-.18-1.166-.802-1.166-.802.756-1.081 1.753-1.502 3.132-1.502.975 0 1.803.327 2.394.948s.928 1.509 1.005 2.644q.492.207.905.484c1.109.745 1.719 1.86 1.719 3.137 0 2.716-2.226 5.075-6.256 5.075C4.594 16 1 13.987 1 7.994 1 2.034 4.482 0 8.044 0 9.69 0 13.55.243 15 5.036l-1.36.353C12.516 1.974 10.163 1.43 8.006 1.43c-3.565 0-5.582 2.171-5.582 6.79 0 4.143 2.254 6.343 5.63 6.343 2.777 0 4.847-1.443 4.847-3.556 0-1.438-1.208-2.127-1.27-2.127-.236 1.234-.868 3.31-3.644 3.31-1.618 0-3.013-1.118-3.013-2.582 0-2.09 1.984-2.847 3.55-2.847.586 0 1.294.04 1.663.114 0-.637-.54-1.728-1.9-1.728-1.25 0-1.566.405-1.967.868ZM8.716 8.19c-2.04 0-2.304.87-2.304 1.416 0 .878 1.043 1.168 1.6 1.168 1.02 0 2.067-.282 2.232-2.423a6.2 6.2 0 0 0-1.528-.161' ],
			'width'  => 16,
			'height' => 16,
			'pro'    => true,
		],
	];

	/**
	 *
	 *
	 * @param string $slug
	 * @return array|bool
	 */
	public static function get_icon( $slug = '' ) {
		if ( empty( $slug ) ) {
			return false;
		}

		if ( $slug == 'twitter' ) :
			$settings = \Mediavine\Grow\Settings::get_setting( 'dpsp_settings', [] );
			if ( ! empty($settings['twitter_4ever']) ) :
				return self::$icons[ $slug ];
			else : 
				return self::$icons[ 'x' ];
			endif;
		endif;

		return self::$icons[ $slug ];
	}

	/**
	 *
	 *
	 * @return array[]
	 */
	public static function get_icons() {
		$settings = \Mediavine\Grow\Settings::get_setting( 'dpsp_settings', [] );
		$all_icons = self::$icons;

		if ( ! empty($settings['twitter_4ever']) ) : // This beautiful person would like to see Twitter intead of X
			$x_icon = $all_icons['x'];
			unset($all_icons['x']);
			$filtered_icons = array_replace( $all_icons, array( 'twitter', $x_icon ) ); // Twitter becomes X, let that sink in
		else : 
			$filter_icons = self::$icons;
			unset($filtered_icons['x']); // remove X, keep Twitter
		endif;

		return $filtered_icons;

	}
}
