<?php
/**
* The template for displaying Comments.
*
* The area of the page that contains both current comments
* and the comment form. The actual display of comments is
* handled by a callback to natural_comment() which is
* located in the functions.php file.
*
* @package Natural
* @since Natural 3.0
*
*/
?>
	<div id="comments">
	<?php if ( post_password_required() ) : ?>
		<p class="nopassword"><?php _e( 'Este post está protegido por senha. Insira a senha para visualizar os comentários.', 'organicthemes' ); ?></p>
	</div><!-- #comments -->
	<?php
			/* Stop the rest of comments.php from being processed,
			* but don't kill the script entirely -- we still have
			* to fully load the template.
			*/
			return;
		endif;
	?>

	<?php // You can start editing here -- including this comment! ?>

	<?php if ( have_comments() ) : ?>
		<h3 id="comments-title">
			<?php
				printf( _n( '1 Comentário em &ldquo;%2$s&rdquo;', '%1$s Comentários em &ldquo;%2$s&rdquo;', get_comments_number(), 'organicthemes' ),
					number_format_i18n( get_comments_number() ), '<span>' . get_the_title() . '</span>' );
			?>
		</h3>

		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
		<nav id="comment-nav-above">
			<h1 class="assistive-text"><?php _e( 'Navegação nos comentários', 'organicthemes' ); ?></h1>
			<div class="nav-previous"><?php previous_comments_link( __( '&larr; Mais antigos', 'organicthemes' ) ); ?></div>
			<div class="nav-next"><?php next_comments_link( __( 'Mais recentes &rarr;', 'organicthemes' ) ); ?></div>
		</nav>
		<?php endif; // check for comment navigation ?>

		<ol class="commentlist">
			<?php
				/* Loop through and list the comments. Tell wp_list_comments()
				* to use natural_comment() to format the comments.
				* If you want to overload this in a child theme then you can
				* define natural_comment() and that will be used instead.
				* See natural_comment() in organicthemes/functions.php for more.
				*/
				wp_list_comments( array( 'callback' => 'natural_comment' ) );
			?>
		</ol>

		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
		<nav id="comment-nav-below">
			<h1 class="assistive-text"><?php _e( 'Navegação nos comentários', 'organicthemes' ); ?></h1>
			<div class="nav-previous"><?php previous_comments_link( __( '&larr; Mais antigos', 'organicthemes' ) ); ?></div>
			<div class="nav-next"><?php next_comments_link( __( 'Mais recentes &rarr;', 'organicthemes' ) ); ?></div>
		</nav>
		<?php endif; // check for comment navigation ?>

	<?php
		/* If there are no comments and comments are closed, let's leave a little note, shall we?
		* But we don't want the note on pages or post types that do not support comments.
		*/
		elseif ( ! comments_open() && post_type_supports( get_post_type(), 'comments' ) ) :
	?>
		<p class="nocomments"><?php _e( 'Comentários desabilitados.', 'organicthemes' ); ?></p>
	<?php endif; ?>

	<?php comment_form(); ?>

</div><!-- #comments -->