<?php

/**

* The Header for our theme.

* Displays all of the <head> section and everything up till <div id="wrap">

*

* @package Natural

* @since Natural 3.0

*

*/

?><!DOCTYPE html>



<!-- paulirish.com/2008/conditional-stylesheets-vs-css-hacks-answer-neither/ -->

<!--[if lt IE 7]> <html class="no-js ie6 oldie" <?php language_attributes(); ?>> <![endif]-->

<!--[if IE 7]>    <html class="no-js ie7 oldie" <?php language_attributes(); ?>> <![endif]-->

<!--[if IE 8]>    <html class="no-js ie8 oldie" <?php language_attributes(); ?>> <![endif]-->

<!-- Consider adding an manifest.appcache: h5bp.com/d/Offline -->

<!--[if gt IE 8]><!--> <html class="no-js" <?php language_attributes(); ?>> <!--<![endif]-->



<head>



<meta charset="<?php bloginfo('charset'); ?>">



<?php if(of_get_option('enable_responsive') == '1') { ?>

<!-- Mobile View -->

<meta name="viewport" content="width=device-width">

<?php } ?>



<title><?php wp_title( '|', true, 'right' ); ?></title>

<link rel="Shortcut Icon" href="<?php echo get_template_directory_uri(); ?>/images/favicon.png" type="image/x-icon">



<?php get_template_part( 'style', 'options' ); ?>



<link rel="profile" href="http://gmpg.org/xfn/11">

<link rel="pingback" href="<?php echo esc_url( bloginfo('pingback_url') ); ?>">



<!-- Social Buttons -->

<script src="http://platform.twitter.com/widgets.js" type="text/javascript"></script>

<script type="text/javascript" src="https://apis.google.com/js/plusone.js"></script>



<?php wp_head(); ?>

<script>

  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){

  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),

  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)

  })(window,document,'script','//www.google-analytics.com/analytics.js','ga');



  ga('create', 'UA-47721778-1', 'auto');

  ga('send', 'pageview');



</script>



<link href="https://fonts.googleapis.com/css?family=Damion" rel="stylesheet">

</head>



<body <?php body_class(); ?>>



<!-- BEGIN #wrap -->

<div id="wrap">



	<!-- BEGIN .container -->

	<div class="container">

	

		<!-- BEGIN #header -->

		<div id="header">

		

			<!-- BEGIN .row -->

			<div class="row">

				

				<!-- BEGIN .sixteen columns -->

				<div class="sixteen columns">

				

				<?php if (is_home() || is_front_page() ) { ?>

					<?php $natural_logo = natural_get_logo_url(); if ( ! empty( $natural_logo ) ) { ?>

						<h1 id="logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url( natural_get_logo_url() ); ?>" alt="<?php esc_attr( bloginfo('name') ); ?>" /><?php bloginfo( 'name' ); ?></a></h1>

					<?php } else { ?>

						<div id="masthead">

							<h1 class="site-title"><span><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo wp_kses_post( get_bloginfo( 'name' ) ); ?></a></span></h1>

							<h2 class="site-description"><?php echo wp_kses_post( get_bloginfo( 'description' ) ); ?></h2>

						</div>

					<?php } ?>

				<?php } else { ?>

					<?php $natural_logo = natural_get_logo_url(); if ( ! empty( $natural_logo ) ) { ?>

						<p id="logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url( natural_get_logo_url() ); ?>" alt="<?php esc_attr( bloginfo('name') ); ?>" /><?php bloginfo( 'name' ); ?></a></p>

					<?php } else { ?>

						<div id="masthead">

							<h4 class="site-title"><span><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo wp_kses_post( get_bloginfo( 'name' ) ); ?></a></span></h4>

							<h5 class="site-description"><?php echo wp_kses_post( get_bloginfo( 'description' ) ); ?></h5>

						</div>

					<?php } ?>

				<?php } ?>

				

				<?php $header_image = get_header_image(); if ( ! empty( $header_image ) ) { ?>

					<div id="custom-header"><img src="<?php header_image(); ?>" height="<?php echo get_custom_header()->height; ?>" width="<?php echo get_custom_header()->width; ?>" alt="<?php esc_attr( bloginfo('name') ); ?>" /></div>

				<?php } ?>		

				<!-- END .sixteen columns -->

				</div>

				<div class="visita">
					<a href="https://www.expressextintores.com.br/solicitacao-de-visita/"><img src="https://www.expressextintores.com.br/wp-content/uploads/visita.png"></a> 
				</div>

				<div class="top">
					<p>
					<a href="https://wa.me/5516997224703?text=Ol%C3%A1%2C%20visitei%20o%20seu%20site%20e%20gostaria%20de%20mais%20informa%C3%A7%C3%B5es%21" title="Chamar no Whatsapp" target="_blank"><img src="https://www.expressextintores.com.br/wp-content/uploads/whats.png"></a>
					<a href="https://wa.me/5516997224703?text=Ol%C3%A1%2C%20visitei%20o%20seu%20site%20e%20gostaria%20de%20mais%20informa%C3%A7%C3%B5es%21" title="Ligue agora mesmo" target="_blank"><img src="https://www.expressextintores.com.br/wp-content/uploads/tel.png"></a>	
			
					</p>					
				</div>
			

			<!-- END .row -->

			</div>

		

		<!-- END #header -->

		</div>

		

		<!-- BEGIN #navigation -->

		<nav id="navigation" class="navigation-main shadow <?php if ( is_home() ) { ?>radius-top home-nav<?php } else { ?>radius-full<?php } ?>" role="navigation">

		

			<!-- BEGIN .row -->

			<div class="row">

				

				<h1 class="menu-toggle"><?php _e( 'Menu', 'organicthemes' ); ?></h1>

	

				<?php if ( has_nav_menu( 'header-menu' ) ) {

					wp_nav_menu( array(

						'theme_location' => 'header-menu',

						'title_li' => '',

						'depth' => 4,

						'container_class' => '',

						'menu_class'      => 'menu'

						)

					);

				} else { ?>

					<ul class="menu"><?php wp_list_pages('title_li=&depth=4'); ?></ul>

				<?php } ?>

				

			<!-- END .row -->

			</div>

		

		<!-- END #navigation -->

		</nav>