<?php
/*
Plugin Name: Page Expiration Robot
Plugin URI: http://www.PageExpirationRobot.com
Description: The official #1 most powerful, scarcity free countdown plugin ever created for WordPress to create evergreen campaigns to expire posts AND pages on a visitor-by-visitor basis!
Version: 3.2.1
Author: IMW Enterprises
Author URI: http://www.IMWenterprises.com/
License: GPLv2 or later
*/
//error_reporting(1);
class PageExpirationRobotSAAS
{

    static $perAppURL = 'https://app.pageexpirationrobot.com';
    static $SAASURL = 'https://app.pageexpirationrobot.com';
    static $appWebURL= 'https://pageexpirationrobot.com/v2/';
    static $pluginURL; 
    static $pluginName = 'Page Expiration Robot';
    static $dash = 'page_expiration_robot_saas';

    public function __construct(){

        self::$pluginURL = plugin_dir_url( __FILE__ );
        
        add_action('admin_menu', array($this,'admin_menu'));
        add_action('admin_menu', array($this,'button_init'));
        
        add_shortcode("PERSAAS",array($this,'showPERSAAS'));
        add_action("admin_init", array($this,"ur_theme_start_session"));

        add_action( 'wp_ajax_loginPERSAAS', array($this, 'loginPERSAAS') );
        add_action( 'wp_ajax_loginRedirect', array($this, 'loginRedirect') );
        add_action( 'wp_ajax_destroyLogin', array($this, 'destroyLogin') );
        add_action('wp_ajax_get_SAAS_camps',  array($this, 'get_SAAS_camps'));

        add_action( 'admin_enqueue_scripts', array($this, 'wppersaas_scripts') );

    }

    function ur_theme_start_session(){

    if (session_status() == PHP_SESSION_NONE){
            session_start();
        }

    }

    function wppersaas_scripts(){

        wp_register_script( 'PERSAAS-script-main1', plugins_url( '/js/js.js', __FILE__ ), '0.1.17', NULL, false  );
    
        wp_enqueue_script( 'PERSAAS-script-main1' );

        wp_register_style( 'main-PERSAAS-style', plugins_url( '/css/css.css', __FILE__ ), '0.0.2', NULL, 'all' );

        wp_enqueue_style( 'main-PERSAAS-style' );

    }

    public function admin_menu(){

        add_menu_page( self::$pluginName, self::$pluginName, 'edit_others_posts', self::$dash, array($this,'campaignsSAAS'), self::$pluginURL."images/per_icon.png");

        add_submenu_page(self::$dash, 'Timers', 'Timers', 'edit_others_posts', self::$dash, array($this,'campaignsSAAS'));

        add_submenu_page(self::$dash, 'New Capaign', 'Create New Campaign', 'edit_others_posts', self::$dash.'_add', array($this,'newCampaign'));

        add_submenu_page(self::$dash, 'Settings', 'Settings', 'edit_others_posts', self::$dash.'_settings', array($this,'settings'));
        add_submenu_page(self::$dash, 'Open PER Everywhere', 'Open PER Everywhere', 'edit_others_posts', self::$dash.'openSAAS', array($this,'openSaas'));


        add_submenu_page(self::$dash, 'Help', 'Help', 'edit_others_posts', self::$dash.'_help', array($this,'help'));

	}

    function loginRedirect(){

         header('Location:'.admin_url("admin.php?page=".self::$dash));
    }

    function destroyLogin(){

        unset($_SESSION['username']);
        unset($_SESSION['password']);

    }

    function loginPERSAAS(){

        $username = $_POST['username'];
        $password = $_POST['password'];
        $pluginLoginSAAS = 'pluginLoginSAAS';

        $arg = array(
            'method' => 'POST',
            'timeout' => 45,
            'redirection' => 5,
            'httpversion' => '1.0',
            'blocking' => true,
            'headers' => array(),
            'body' => array( 'username' => $username,
                'password' => $password,
                'pluginLoginSAAS' => $pluginLoginSAAS
                ),
            'cookies' => array()
        );

        $result = wp_remote_post( self::$SAASURL.'/login_process.php', $arg );

       $res =  $result['body'];

       if($res == '1'){

           if(!isset($_SESSION['username'])){

                $_SESSION['username'] = $username;
                $_SESSION['password'] = $password;

           }

       }else{

           if(isset($_SESSION['username'])){

                unset($_SESSION['username']);
                unset($_SESSION['password']);

           }

       }

       $opt = trim(get_option( 'per_saas_username' ));

       if (empty($opt)) {

            add_option( 'per_saas_username', $username, 'yes' );

        }else{

            update_option( 'per_saas_username', $username, 'yes' );

        }

       echo $res;
        
       exit();
        
    }

    public function campaignsSAAS(){

        require("campaigns.php");

    }
    
    public function newCampaign(){

        require("newCampaign.php");

    }

    public function settings(){

        require("settings.php");

    }

    public function openSaas(){
    
        echo '<script>window.location.replace("https://app.pageexpirationrobot.com/log-in.php");</script>';
 
    }


    public function help(){
    
        echo '<script>window.location.replace("https://pageexpirationrobot.helpscoutdocs.com/collection/120-web-app-faq");</script>';
 
    }

    public function showPERSAAS($atts){

        $js = '';

        if($atts['ev'] == 0){
                  
            $js = "<script src='//app.pageexpirationrobot.com/redirect.js' class='<?php echo $camp_id; ?>'></script>" ;
            
        }else if($atts['ev'] == 1){

            $js = "<script src='//app.pageexpirationrobot.com/redirectnew.js' class='<?php echo $camp_id; ?>'></script>"; 

        }else if($atts['ev'] == 3){

            $js = "<script src='//app.pageexpirationrobot.com/timedcontent.js' class='<?php echo $camp_id; ?>'></script>"; 

        }   

        return "<script src='".self::$perAppURL."/timedcontent.js' class='".$atts['id']."'></script><iframe src='".self::$perAppURL."/frontend.php?camp_id=".$atts['id']."&user_id=".$atts['user']."' scrolling='no' height='100' width='401' frameborder='0'  ></iframe>".$js;

    }

    function button_init() {
		
		if ( current_user_can( 'edit_posts' ) && current_user_can( 'edit_pages' ) ) {
			add_filter( 'mce_buttons', array( $this, 'filter_mce_button' ) );
			add_filter( 'mce_external_plugins', array( $this, 'filter_mce_plugin' ) );
		}
	}
	
	function filter_mce_button( $buttons ) {
		// add a separation before our button, here our button's id is "myshortcode_button"
		array_push( $buttons, '|', 'perSAAS_editor_button' );
		return $buttons;
	}
	
	function filter_mce_plugin( $plugins ) {
		
		$plugins['perSAAS_editor_button'] = plugin_dir_url( __FILE__ ).'/js/shortcode.js';
		return $plugins;
	}	

    function get_SAAS_camps(){

        $arg = array(
            'method' => 'POST',
            'timeout' => 45,
            'redirection' => 5,
            'httpversion' => '1.0',
            'blocking' => true,
            'headers' => array(),
            'body' => array( 'username' => trim(get_option( 'per_saas_username' ))
                ),
            'cookies' => array()
        );

        $result = wp_remote_post( self::$SAASURL.'/plugin/getShortcodes.php', $arg );

        $camps = json_decode($result['body'], true);

        $output = '';

        foreach($camps as $camp){

            $output .= '<option value="'.$camp['campaign_id'].'">'.$camp['campaing_name'].'</option>';

        }

        echo '<select id="perSAASShrt" >'.$output.'</select><br><input type="button" value="Insert" class="button button-primary button-large" id="insertShortcode">';

        exit();

    }

}

$PERSAAS = new PageExpirationRobotSAAS();

?>
