"use strict";!function(blocks,components,blockEditor,i18n,element){var el=element.createElement,registerBlockType=blocks.registerBlockType,TextControl=components.TextControl,SelectControl=components.SelectControl,ToggleControl=components.ToggleControl,RangeControl=(components.Button,components.RangeControl),SVG=components.SVG,Path=components.Path,InspectorControls=wp.blockEditor.InspectorControls,apiFetch=wp.apiFetch,useEffect=wp.element.useEffect;registerBlockType("getbowtied/categories-grid",{title:i18n.__("Product Categories Grid"),icon:el(SVG,{key:"getbowtied-categories-grid-icon",xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24"},el(Path,{key:"getbowtied-categories-grid-icon-path",d:"M20 2H4c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM8 20H4v-4h4v4zm0-6H4v-4h4v4zm0-6H4V4h4v4zm6 12h-4v-4h4v4zm0-6h-4v-4h4v4zm0-6h-4V4h4v4zm6 12h-4v-4h4v4zm0-6h-4v-4h4v4zm0-6h-4V4h4v4z"})),category:"product_blocks",description:i18n.__("Display a grid of products from your selected categories."),keywords:[i18n.__("product categories"),i18n.__("grid"),i18n.__("thumbs")],supports:{align:["center","wide","full"]},styles:[{name:"layout-1",label:"Layout 1"},{name:"layout-2",label:"Layout 2",isDefault:!0},{name:"layout-3",label:"Layout 3"}],attributes:{categoryIDs:{type:"string",default:""},queryCategories:{type:"string",default:""},queryCategoriesLast:{type:"string",default:""},queryDisplayType:{type:"string",default:"all_categories"},isLoading:{type:"boolean",default:!1},querySearchString:{type:"string",default:""},querySearchResults:{type:"array",default:[]},querySearchNoResults:{type:"boolean",default:!1},querySearchSelected:{type:"array",default:[]},queryOrder:{type:"string",default:""},parentOnly:{type:"boolean",default:!1},hideEmpty:{type:"boolean",default:!1},orderby:{type:"string",default:"menu_order"},productCount:{type:"boolean",default:!0},firstLoad:{type:"boolean",default:!0},limit:{type:"integer",default:8},columns:{type:"integer",default:3}},edit:function(props){function getQuery(query){return"/wc/v3/products/categories"+query}function getResult(query){null===query&&(query="all_categories"==attributes.queryDisplayType?_buildQuery(attributes.limit,attributes.orderby,attributes.parentOnly,attributes.hideEmpty):attributes.queryCategories,useEffect(function(){props.setAttributes({queryCategoriesLast:query})})),""!=query&&apiFetch({path:query}).then(function(categories){"menu_order"==attributes.orderby&&"all_categories"==attributes.queryDisplayType&&categories.sort(function(a,b){return a.menu_order>b.menu_order?1:-1}),props.setAttributes({result:categories}),props.setAttributes({isLoading:!1}),!1===attributes.doneFirstLoad&&props.setAttributes({querySearchSelected:categories}),props.setAttributes({doneFirstLoad:!0});for(var IDs="",i=0;i<categories.length;i++)IDs+=categories[i].id+",";props.setAttributes({categoryIDs:IDs})})}function _buildQuery(){var limit=0<arguments.length&&void 0!==arguments[0]?arguments[0]:10,orderby=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"menu_order",parentOnly=!(2<arguments.length&&void 0!==arguments[2])||arguments[2],hideEmpty=!(3<arguments.length&&void 0!==arguments[3])||arguments[3];if("specific"===attributes.queryDisplayType)return attributes.queryCategories;var query=getQuery("?per_page="+limit);switch(orderby){case"menu_order":break;case"title_asc":query+="&orderby=slug&order=asc";break;case"title_desc":query+="&orderby=slug&order=desc"}return!0===parentOnly&&(query+="&parent=0"),!0===hideEmpty&&(query+="&hide_empty=true"),query}var className=props.className,attributes=props.attributes;return attributes.selectedIDS=attributes.selectedIDS||[],attributes.doneFirstLoad=attributes.doneFirstLoad||!1,attributes.result=attributes.result||[],-1==className.indexOf("is-style-layout")&&(className+=" is-style-layout-2"),[el(InspectorControls,{key:"products-main-inspector"},el("div",{className:"products-main-inspector-wrapper"},el(SelectControl,{key:"gbt-categories-grid-query-panel-select",label:i18n.__("Source:"),value:attributes.queryDisplayType,options:[{label:i18n.__("Manually pick"),value:"specific"},{label:i18n.__("All Categories"),value:"all_categories"}],onChange:function(value){return props.setAttributes({queryDisplayType:value})}}),"specific"===attributes.queryDisplayType&&el("div",{key:"gbt-categories-grid-query-ajax-search-wrapper",className:"products-ajax-search-wrapper"},el(TextControl,{key:"gbt-categories-grid-query-panel-string",type:"search",className:"products-ajax-search",value:attributes.querySearchString,placeholder:i18n.__("Search for categories to display"),onChange:function(newQuery){if(props.setAttributes({querySearchString:newQuery}),!(newQuery.length<3)){var query=getQuery("?per_page=10&search="+newQuery);apiFetch({path:query}).then(function(categories){0==categories.length?props.setAttributes({querySearchNoResults:!0}):props.setAttributes({querySearchNoResults:!1}),props.setAttributes({querySearchResults:categories})})}}})),"specific"===attributes.queryDisplayType&&""!=attributes.querySearchString&&el("div",{key:"gbt-categories-grid-specific-ajax-search-results",className:"products-ajax-search-results"},function(){var categoryElements=[];if(1==attributes.querySearchNoResults)return el("span",{key:"gbt-categories-grid-noresults",className:"no-results"},i18n.__("No categories matching."));for(var theID,categories=attributes.querySearchResults,i=0;i<categories.length;i++){var img=void 0;img=null!==categories[i].image&&""!=categories[i].image.src?el("span",{key:"gbt-categories-grid-img-wrapper"+i,className:"img-wrapper",dangerouslySetInnerHTML:{__html:'<span class="img" style="background-image: url(\''+categories[i].image.src+"')\"></span>"}}):el("span",{key:"gbt-categories-grid-img-wrapper"+i,className:"img-wrapper",dangerouslySetInnerHTML:{__html:'<span class="img" style="background-image: url(\''+getbowtied_pbw.woo_placeholder_image+"')\"></span>"}}),categoryElements.push(el("span",{key:"gbt-categories-grid-cat-item-"+categories[i].id,className:(theID=categories[i].id,-1==attributes.selectedIDS.indexOf(theID)?"single-result":"single-result selected"),title:categories[i].name.replace(/&amp;/g,"&"),"data-index":i},img,el("label",{key:"gbt-categories-grid-cat-item-label-"+i,className:"title-wrapper"},el("input",{key:"gbt-categories-grid-cat-item-input-"+i,type:"checkbox",value:i,onChange:function(evt){evt.target;var qSR=attributes.selectedIDS,index=qSR.indexOf(categories[evt.target.value].id);-1==index?qSR.push(categories[evt.target.value].id):qSR.splice(index,1),props.setAttributes({selectedIDS:qSR});var query=getQuery("?include="+qSR.join(",")+"&orderby=include");0<qSR.length?props.setAttributes({queryCategories:query}):props.setAttributes({queryCategories:""}),apiFetch({path:query}).then(function(categories){props.setAttributes({querySearchSelected:categories})})}}),categories[i].name.replace(/&amp;/g,"&"),el("span",{key:"gbt-categories-grid-cat-item-dashicon-yes-"+i,className:"dashicons dashicons-yes"}),el("span",{key:"gbt-categories-grid-cat-item-dashivon-noalt-"+i,className:"dashicons dashicons-no-alt"}))))}return categoryElements}()),"specific"===attributes.queryDisplayType&&0<attributes.querySearchSelected.length&&el("div",{key:"gbt-categories-grid-specific-results-wrapper",className:"products-selected-results-wrapper"},el("label",{key:"gbt-categories-grid-specific-results-label"},i18n.__("Selected Products:")),el("div",{key:"gbt-categories-grid-specific-selected-results",className:"products-selected-results"},function(){var categoryElements=[],categories=attributes.querySearchSelected;if(attributes.selectedIDS.length<1&&0<categories.length){for(var bugFixer=[],_i=0;_i<categories.length;_i++)bugFixer.push(categories[_i].id);useEffect(function(){props.setAttributes({selectedIDS:bugFixer})})}for(var _i2=0;_i2<categories.length;_i2++){var img="";img=null!==categories[_i2].image&&""!=categories[_i2].image.src?el("span",{key:"gbt-categories-grid-search-item-"+_i2,className:"img-wrapper",dangerouslySetInnerHTML:{__html:'<span class="img" style="background-image: url(\''+categories[_i2].image.src+"')\"></span>"}}):el("span",{key:"gbt-categories-grid-search-item-"+_i2,className:"img-wrapper",dangerouslySetInnerHTML:{__html:'<span class="img" style="background-image: url(\''+getbowtied_pbw.woo_placeholder_image+"')\"></span>"}}),categoryElements.push(el("span",{key:"gbt-categories-grid-search-item-"+categories[_i2].id,className:"single-result",title:categories[_i2].name.replace(/&amp;/g,"&")},img,el("label",{key:"gbt-categories-grid-search-item-label-"+_i2,className:"title-wrapper"},el("input",{key:"gbt-categories-grid-search-item-checkbox-"+_i2,type:"checkbox",value:_i2,onChange:function(evt){evt.target;var qSS=attributes.selectedIDS,index=qSS.indexOf(categories[evt.target.value].id);-1!=index&&qSS.splice(index,1),props.setAttributes({selectedIDS:qSS});var query=getQuery("?include="+qSS.join(",")+"&orderby=include");0<qSS.length?(props.setAttributes({queryCategories:query}),apiFetch({path:query}).then(function(categories){props.setAttributes({querySearchSelected:categories})})):(props.setAttributes({queryCategories:""}),props.setAttributes({querySearchSelected:[]}))}}),categories[_i2].name.replace(/&amp;/g,"&"),el("span",{key:"gbt-categories-grid-search-item-dashicon-noalt-"+_i2,className:"dashicons dashicons-no-alt"}))))}return categoryElements}())),"all_categories"===attributes.queryDisplayType&&[el(SelectControl,{key:"gbt-categories-grid-order-by",options:[{value:"menu_order",label:"Menu Order"},{value:"title_asc",label:"Alphabetical Ascending"},{value:"title_desc",label:"Alphabetical Descending"}],label:i18n.__("Order By"),value:attributes.orderby,onChange:function(value){props.setAttributes({orderby:value})}}),el(RangeControl,{key:"gbt-categories-grid-display-number",value:attributes.limit,allowReset:!1,initialPosition:8,min:1,max:100,label:i18n.__("How many product categories to display?"),onChange:function(value){props.setAttributes({limit:value})}}),el(ToggleControl,{id:"categories-grid-display",key:"gbt-categories-grid-display",label:i18n.__("Parent Categories Only"),checked:attributes.parentOnly,onChange:function(value){props.setAttributes({parentOnly:value})}}),el(ToggleControl,{key:"gbt-categories-grid-hide-empty",label:i18n.__("Hide Empty"),checked:attributes.hideEmpty,onChange:function(value){props.setAttributes({hideEmpty:value})}})],el("button",{key:"gbt-categories-grid-load-button",className:"render-results components-button is-button is-default is-primary is-large "+(!0===attributes.isLoading?"is-busy":""),disabled:0==attributes.queryCategories.length||_buildQuery(attributes.limit,attributes.orderby,attributes.parentOnly,attributes.hideEmpty)===attributes.queryCategoriesLast,onClick:function(e){var query=void 0;props.setAttributes({isLoading:!0}),props.setAttributes({querySearchString:""}),props.setAttributes({querySearchResults:[]}),query="all_categories"==attributes.queryDisplayType?_buildQuery(attributes.limit,attributes.orderby,attributes.parentOnly,attributes.hideEmpty):attributes.queryCategories,props.setAttributes({queryCategoriesLast:query}),getResult(query)}},!1===attributes.isLoading?i18n.__("Update"):i18n.__("Updating"))),el("div",{className:"products-main-inspector-wrapper"},el(ToggleControl,{key:"gbt-categories-grid-product-count",label:i18n.__("Product Count"),checked:attributes.productCount,onChange:function(value){props.setAttributes({productCount:value})}}),-1!==props.className.indexOf("is-style-layout-1")&&el(RangeControl,{key:"gbt-categories-grid-layout-1-columns",value:attributes.columns,allowReset:!1,initialPosition:3,min:2,max:6,label:i18n.__("Columns"),onChange:function(newColumns){props.setAttributes({columns:newColumns})}}))),el("div",{key:"gbt-categories-grid-results"},attributes.result.length<1&&!1===attributes.doneFirstLoad&&getResult(null),function(){if(!0===attributes.firstLoad){var query=_buildQuery(attributes.limit,attributes.orderby,attributes.parentOnly,attributes.hideEmpty);apiFetch({path:query}).then(function(categories){categories=function _sortCategories(index,arr){for(var newarr=2<arguments.length&&void 0!==arguments[2]?arguments[2]:[],level=3<arguments.length&&void 0!==arguments[3]?arguments[3]:0,i=0;i<arr.length;i++)arr[i].parent==index&&(arr[i].level=level,newarr.push(arr[i]),_sortCategories(arr[i].id,arr,newarr,level+1));return newarr}(0,categories),props.setAttributes({result:categories}),props.setAttributes({firstLoad:!1}),props.setAttributes({queryCategories:query}),props.setAttributes({queryCategoriesLast:query});for(var IDs="",i=0;i<categories.length;i++)IDs+=categories[i].id+",";props.setAttributes({categoryIDs:IDs})})}for(var categories=attributes.result,categoryElements=[],wrapper=[],class_prefix="gbt_18_editor_category_grid_item",i=0;i<categories.length;i++){var img="";img=null!==categories[i].image?categories[i].image.src:getbowtied_pbw.woo_placeholder_image,categoryElements.push(el("div",{key:"gbt-category-grid-item-"+categories[i].id,className:class_prefix},el("a",{key:"gbt-category-grid-item-a-"+i,className:class_prefix+"_img"},el("img",{key:"gbt-category-grid-item-img-"+i,className:class_prefix+"_thumb",src:img}),el("h4",{key:"gbt-category-grid-item-h4-"+i,className:class_prefix+"_title"},categories[i].name.replace(/&amp;/g,"&"),!0===attributes.productCount&&el("span",{key:"gbt-category-grid-item-count-"+i,className:class_prefix+"_count"},categories[i].count)))))}return wrapper.push(el("div",{key:"gbt_18_editor_categories_grid_wrapper",className:className+" gbt_18_editor_categories_grid_wrapper"},el("div",{key:"gbt_18_editor_categories_grid",className:"gbt_18_editor_categories_grid "+props.className+" "+(-1!==props.className.indexOf("is-style-layout-1")?"columns-"+attributes.columns:"")},categoryElements,el("div",{key:"gbt_18_editor_categories_grid_clearfix",className:"clearfix"})))),wrapper}())]},save:function(){}})}(window.wp.blocks,window.wp.components,window.wp.editor,window.wp.i18n,window.wp.element,jQuery);