"use strict";!function(blocks,components,blockEditor,i18n,element){var el=element.createElement,registerBlockType=blocks.registerBlockType,TextControl=components.TextControl,SelectControl=components.SelectControl,RangeControl=(components.ToggleControl,components.Button,components.RangeControl),SVG=components.SVG,Path=components.Path,InspectorControls=wp.blockEditor.InspectorControls,apiFetch=wp.apiFetch;registerBlockType("getbowtied/products-carousel",{title:i18n.__("Product Carousel"),icon:el(SVG,{key:"getbowtied-product-carousel-icon",xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24"},el(Path,{key:"getbowtied-product-carousel-icon-path",d:"M 7 3 A 1.0001 1.0001 0 0 0 6 4 L 6 5 L 3 5 A 1.0001 1.0001 0 0 0 2 6 L 2 18 A 1.0001 1.0001 0 0 0 3 19 L 6 19 L 6 20 A 1.0001 1.0001 0 0 0 7 21 L 17 21 A 1.0001 1.0001 0 0 0 18 20 L 18 19 L 21 19 A 1.0001 1.0001 0 0 0 22 18 L 22 6 A 1.0001 1.0001 0 0 0 21 5 L 18 5 L 18 4 A 1.0001 1.0001 0 0 0 17 3 L 7 3 z M 8 5 L 16 5 L 16 5.8320312 A 1.0001 1.0001 0 0 0 16 6.1582031 L 16 17.832031 A 1.0001 1.0001 0 0 0 16 18.158203 L 16 19 L 8 19 L 8 18.167969 A 1.0001 1.0001 0 0 0 8 17.841797 L 8 6.1679688 A 1.0001 1.0001 0 0 0 8 5.8417969 L 8 5 z M 4 7 L 6 7 L 6 17 L 4 17 L 4 7 z M 18 7 L 20 7 L 20 17 L 18 17 L 18 7 z"})),category:"product_blocks",description:i18n.__("Display products from your store in a carousel."),keywords:[i18n.__("products"),i18n.__("carousel"),i18n.__("slider")],supports:{align:["center","wide","full"]},attributes:{queryProducts:{type:"string",default:"wc/v3/products?per_page=10"},queryProductsLast:{type:"string",default:"wc/v3/products?per_page=10"},queryDisplayType:{type:"string",default:"all_products"},selectedIDS:{type:"string",default:""},productIDs:{type:"string",default:""},querySearchSelected:{type:"array",default:[]},queryCategoryOptions:{type:"array",default:""},queryCategorySelected:{type:"array",default:[]},queryFilterSelected:{type:"string",default:""},queryAttributesSelected:{type:"string",default:""},queryAttributesOptions:{type:"array",default:[]},queryAttributesOptionsValues:{type:"array",default:[]},queryAttributesSelectedSlug:{type:"string",default:""},queryAttributesOptionsSelected:{type:"array",default:[]},queryOrder:{type:"string",default:""},columns:{type:"integer",default:3},spaceBetween:{type:"integer",default:30},limit:{type:"integer",default:10}},edit:function(props){function _categoryClassName(parent,value){return 0==parent?"parent parent-"+value:"child child-"+parent}function toArray(s){var ret=[];0<s.length&&(ret=s.split(","));for(var i=0;i<ret.length;i++)""==ret[i]?ret.splice(i,1):ret[i]=Number(ret[i]);return ret}function _destroyQuery(){props.setAttributes({queryOrder:""}),props.setAttributes({queryProducts:""}),props.setAttributes({querySearchString:""}),props.setAttributes({querySearchResults:[]}),props.setAttributes({querySearchSelected:[]}),props.setAttributes({selectedIDS:[]}),props.setAttributes({queryAttributesOptionsSelected:[]}),props.setAttributes({queryCategorySelected:[]}),props.setAttributes({result:[]})}function _isChecked(needle,haystack){return-1!=haystack.indexOf(needle.toString())}function getQuery(query){return"wc/v3/products"+query}function getProducts(){var query=attributes.queryProducts;query!=attributes.queryProductsLast&&props.setAttributes({queryProductsLast:query}),""!==query&&apiFetch({path:query}).then(function(products){for(var products_final=[],index=0,i=0;i<products.length;i++)"hidden"!=products[i].catalog_visibility&&(products_final[index]=products[i],index++);products=products_final,props.setAttributes({result:products}),props.setAttributes({isLoading:!1}),!1===attributes.doneFirstLoad&&props.setAttributes({querySearchSelected:products}),props.setAttributes({doneFirstLoad:!0});for(var IDs="",_i=0;_i<products.length;_i++)"hidden"!=products[_i].catalog_visibility&&(IDs+=products[_i].id+",");props.setAttributes({productIDs:IDs}),props.setAttributes({selectedSlide:0})})}function _getQueryOrder(){if(attributes.queryOrder.length<1)return"";var order="";switch(attributes.queryOrder){case"date_desc":order="&orderby=date&order=desc";break;case"date_asc":order="&orderby=date&order=asc";break;case"title_desc":order="&orderby=title&order=desc";break;case"title_asc":order="&orderby=title&order=asc"}return order}function renderOrderby(){var _returnArr=[];return _returnArr.push(el(SelectControl,{key:"query-panel-orderby",label:i18n.__("Order By:"),value:attributes.queryOrder,className:"orderby-wrapper",options:[{label:i18n.__("Newness - newest first"),value:"date_desc"},{label:i18n.__("Newness - oldest first"),value:"date_asc"},{label:i18n.__("Title - ascending"),value:"title_asc"},{label:i18n.__("Title - descending"),value:"title_desc"}],onChange:function(value){props.setAttributes({queryOrder:value}),function(value){var query=attributes.queryProducts;if(!(query.length<1)){var idx=query.indexOf("&orderby");switch(-1<idx&&(query=query.substring(idx,-25)),value){case"date_desc":query+="&orderby=date&order=desc";break;case"date_asc":query+="&orderby=date&order=asc";break;case"title_desc":query+="&orderby=title&order=desc";break;case"title_asc":query+="&orderby=title&order=asc"}props.setAttributes({queryProducts:query})}}(value)}})),_returnArr}function getCategories(){var query=getQuery("/categories?&per_page=100"),options=[],sorted=[];apiFetch({path:query}).then(function(categories){for(var i=0;i<categories.length;i++)options[i]={label:categories[i].name.replace(/&amp;/g,"&"),value:categories[i].id,parent:categories[i].parent,count:categories[i].count};for(var _i4=0;_i4<options.length;_i4++);sorted=function _sortCategories(index,arr){for(var newarr=2<arguments.length&&void 0!==arguments[2]?arguments[2]:[],level=3<arguments.length&&void 0!==arguments[3]?arguments[3]:0,i=0;i<arr.length;i++)arr[i].parent==index&&(arr[i].level=level,newarr.push(arr[i]),_sortCategories(arr[i].value,arr,newarr,level+1));return newarr}(0,options),props.setAttributes({queryCategoryOptions:sorted})})}var attributes=props.attributes;return attributes.selectedSlide=attributes.selectedSlide||0,attributes.result=attributes.result||[],attributes.isLoading=attributes.isLoading||!1,attributes.querySearchString=attributes.querySearchString||"",attributes.querySearchResults=attributes.querySearchResults||[],attributes.querySearchNoResults=attributes.querySearchNoResults||!1,attributes.doneFirstLoad=attributes.doneFirstLoad||!1,[el(InspectorControls,{key:"gbt-product-carousel-inspector"},el("div",{key:"gbt-product-carousel-inspector-wrapper",className:"products-main-inspector-wrapper"},el(SelectControl,{key:"gbt-product-carousel-query-panel-select",label:i18n.__("Source:"),value:attributes.queryDisplayType,options:[{label:i18n.__("Choose an Option"),value:"default"},{label:i18n.__("Manually pick products"),value:"specific"},{label:i18n.__("Display by Category"),value:"by_category"},{label:i18n.__("Filter Products"),value:"filter_by"},{label:i18n.__("All Products"),value:"all_products"}],onChange:function(value){if(""==attributes.queryProducts||!1!==window.confirm(i18n.__("Changing the product source will lose the current selection."))){if(_destroyQuery(),"by_category"===value&&getCategories(),"all_products"===value){var query=getQuery("?per_page="+attributes.limit);props.setAttributes({queryProducts:query})}return props.setAttributes({queryDisplayType:value})}}}),"specific"===attributes.queryDisplayType&&el("div",{key:"gbt-product-carousel-products-ajax-search-wrapper",className:"products-ajax-search-wrapper"},el(TextControl,{key:"gbt-product-carousel-query-panel-string",type:"search",className:"products-ajax-search",value:attributes.querySearchString,placeholder:i18n.__("Search for products to display"),onChange:function(newQuery){if(props.setAttributes({querySearchString:newQuery}),!(newQuery.length<3)){var query=getQuery("?per_page=10&search="+newQuery);apiFetch({path:query}).then(function(products){0==products.length?props.setAttributes({querySearchNoResults:!0}):props.setAttributes({querySearchNoResults:!1}),props.setAttributes({querySearchResults:products})})}}})),"specific"===attributes.queryDisplayType&&0<attributes.querySearchResults.length&&""!=attributes.querySearchString&&el("div",{key:"gbt-product-carousel-products-ajax-search-results",className:"products-ajax-search-results"},function(){var productElements=[];if(!0===attributes.querySearchNoResults)return el("span",{key:"gbt_18_carousel_search-no-results",className:"no-results"},i18n.__("No products matching."));for(var theID,products=attributes.querySearchResults,i=0;i<products.length;i++){var img="";img=products[i].images.length&&void 0!==products[i].images[0].src&&""!=products[i].images[0].src?el("span",{key:"gbt_18_carousel_search-img-wrapper",className:"img-wrapper",dangerouslySetInnerHTML:{__html:'<span class="img" style="background-image: url(\''+products[i].images[0].src+"')\"></span>"}}):el("span",{key:"gbt_18_carousel_search-img-wrapper",className:"img-wrapper",dangerouslySetInnerHTML:{__html:'<span class="img" style="background-image: url(\''+getbowtied_pbw.woo_placeholder_image+"')\"></span>"}}),productElements.push(el("span",{key:"gbt-carousel-search-result-item-"+products[i].id,className:(theID=products[i].id,-1==toArray(attributes.selectedIDS).indexOf(theID)?"single-result":"single-result selected"),title:products[i].name,"data-index":i},img,el("label",{key:"gbt-carousel-search-result-item-title-"+i,className:"title-wrapper"},el("input",{key:"gbt-carousel-search-result-item-input-"+i,type:"checkbox",value:i,onChange:function(evt){evt.target;var qSR=toArray(attributes.selectedIDS),index=qSR.indexOf(products[evt.target.value].id);-1==index?qSR.push(products[evt.target.value].id):qSR.splice(index,1),props.setAttributes({selectedIDS:qSR.join(",")});var query=getQuery("?include="+qSR.join(",")+"&orderby=include");0<qSR.length?props.setAttributes({queryProducts:query}):props.setAttributes({queryProducts:""}),apiFetch({path:query}).then(function(products){props.setAttributes({querySearchSelected:products})})}}),products[i].name,el("span",{key:"gbt-carousel-search-result-item-dashicon-yes-"+i,className:"dashicons dashicons-yes"}),el("span",{key:"gbt-carousel-search-result-item-dashicon-noalt-"+i,className:"dashicons dashicons-no-alt"}))))}return productElements}()),"specific"===attributes.queryDisplayType&&0<attributes.querySearchSelected.length&&el("div",{key:"gbt-product-carousel-products-selected-results-wrapper",className:"products-selected-results-wrapper"},el("label",{key:"gbt-product-carousel-products-selected-results-label"},i18n.__("Selected Products:")),el("div",{key:"gbt-product-carousel-products-selected-results",className:"products-selected-results"},function(){for(var productElements=[],products=attributes.querySearchSelected,_i2=0;_i2<products.length;_i2++){var img="";img=products[_i2].images.length&&void 0!==products[_i2].images[0].src&&""!=products[_i2].images[0].src?el("span",{key:"gbt_18_carousel_search-selected-img-wrapper",className:"img-wrapper",dangerouslySetInnerHTML:{__html:'<span class="img" style="background-image: url(\''+products[_i2].images[0].src+"')\"></span>"}}):el("span",{key:"gbt_18_carousel_search-selected-img-wrapper",className:"img-wrapper",dangerouslySetInnerHTML:{__html:'<span class="img" style="background-image: url(\''+getbowtied_pbw.woo_placeholder_image+"')\"></span>"}}),productElements.push(el("span",{key:"single-result-"+products[_i2].id,className:"single-result",title:products[_i2].name},img,el("label",{key:"gbt-carousel-search-selected-item-label-"+_i2,className:"title-wrapper"},el("input",{key:"gbt-carousel-search-selected-item-checkbox-"+_i2,type:"checkbox",value:_i2,onChange:function(evt){evt.target;var qSS=toArray(attributes.selectedIDS);if(qSS.length<1&&0<attributes.querySearchSelected.length)for(var _i3=0;_i3<attributes.querySearchSelected.length;_i3++)qSS.push(attributes.querySearchSelected[_i3].id);var index=qSS.indexOf(products[evt.target.value].id);-1!=index&&qSS.splice(index,1),props.setAttributes({selectedIDS:qSS.join(",")});var query=getQuery("?include="+qSS.join(",")+"&orderby=include");0<qSS.length?(props.setAttributes({queryProducts:query}),apiFetch({path:query}).then(function(products){props.setAttributes({querySearchSelected:products})})):(props.setAttributes({queryProducts:""}),props.setAttributes({querySearchSelected:[]}))}}),products[_i2].name,el("span",{key:"gbt-carousel-search-selected-item-dashicon-noalt-"+_i2,className:"dashicons dashicons-no-alt"}))))}return productElements}())),"by_category"===attributes.queryDisplayType&&el("div",{key:"gbt-product-carousel-category-result-wrapper",className:"category-result-wrapper"},function renderCategories(){var parent=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0,level=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0,categoryElements=[],catArr=attributes.queryCategoryOptions;if(0<catArr.length)for(var i=0;i<catArr.length;i++)catArr[i].parent==parent&&categoryElements.push(el("li",{key:"gbt-carousel-category-item-"+catArr[i].value,className:"level-"+catArr[i].level},el("label",{key:"gbt-carousel-category-item-label-"+i,className:_categoryClassName(catArr[i].parent,catArr[i].value)+" "+catArr[i].level},el("input",{type:"checkbox",key:"category-checkbox-"+catArr[i].value,value:catArr[i].value,"data-index":i,"data-parent":catArr[i].parent,checked:_isChecked(catArr[i].value,attributes.queryCategorySelected),onChange:function(evt){var idx=Number(evt.target.dataset.index);if(!0===evt.target.checked){var qCS=attributes.queryCategorySelected;-1==qCS.indexOf(evt.target.value)&&qCS.push(evt.target.value);for(var j=idx+1;j<catArr.length-1&&catArr[idx].level<catArr[j].level;j++)-1==qCS.indexOf(catArr[j].value.toString())&&qCS.push(catArr[j].value.toString());props.setAttributes({queryCategorySelected:qCS})}else{var _qCS=attributes.queryCategorySelected,_index=_qCS.indexOf(evt.target.value);-1<_index&&_qCS.splice(_index,1);for(var _j=idx+1;_j<catArr.length-1&&catArr[idx].level<catArr[_j].level;_j++){var _index2=_qCS.indexOf(catArr[_j].value.toString());-1<_index2&&_qCS.splice(_index2,1)}props.setAttributes({queryCategorySelected:_qCS})}if(0<attributes.queryCategorySelected.length){var query=getQuery("?per_page="+attributes.limit+"&category="+attributes.queryCategorySelected.join(","));query+=_getQueryOrder(),props.setAttributes({queryProducts:query})}else props.setAttributes({queryProducts:""})}}),catArr[i].label,el("sup",{key:"gbt-carousel-category-item-count-"+i},catArr[i].count)),renderCategories(catArr[i].value,level+1)));return 0<categoryElements.length?el("ul",{key:"gbt-product-carousel-category-ul",className:"level-"+level},categoryElements):void 0}()),"by_category"===attributes.queryDisplayType&&renderOrderby(),"filter_by"===attributes.queryDisplayType&&el(SelectControl,{key:"gbt-product-carousel-query-panel-filter",value:attributes.queryFilterSelected,options:[{label:"Filter by",value:""},{label:i18n.__("Featured products"),value:"featured"},{label:i18n.__("On sale"),value:"sale"},{label:i18n.__("Attributes"),value:"attributes"}],onChange:function(value){if(_destroyQuery(),props.setAttributes({queryFilterSelected:value}),"attributes"===value)!function(){var query=getQuery("/attributes"),options=[];options.push({label:"Choose",value:" "}),apiFetch({path:query}).then(function(categories){for(var i=0;i<categories.length;i++)options.push({label:categories[i].name.replace(/&amp;/g,"&"),value:categories[i].id});props.setAttributes({queryAttributesOptions:options})})}();else{var query=getQuery("?per_page="+attributes.limit+"&"+value+"=1");props.setAttributes({queryProducts:query})}}}),"filter_by"===attributes.queryDisplayType&&"attributes"===attributes.queryFilterSelected&&el(SelectControl,{key:"gbt-product-carousel-query-panel-attributes",value:attributes.queryAttributesSelected,options:attributes.queryAttributesOptions,onChange:function(value){_destroyQuery(),props.setAttributes({queryAttributesSelected:value}),function(term){var query=getQuery("/attributes/"+term+"/terms"),options=[];apiFetch({path:query}).then(function(attributes){for(var i=0;i<attributes.length;i++)options[i]={label:attributes[i].name.replace(/&amp;/g,"&"),value:attributes[i].id,count:attributes[i].count};props.setAttributes({queryAttributesOptionsValues:options})});var query2=getQuery("/attributes/"+term);apiFetch({path:query2}).then(function(attributes){props.setAttributes({queryAttributesSelectedSlug:attributes.slug})})}(value)}}),"filter_by"===attributes.queryDisplayType&&"attributes"===attributes.queryFilterSelected&&""!==attributes.queryAttributesSelected&&el("div",{key:"gbt-product-carousel-attributes-results-wrapper",className:"attributes-results-wrapper"},function(){var attributeElements=[],attArr=attributes.queryAttributesOptionsValues;if(0<attArr.length)for(var i=0;i<attArr.length;i++)attributeElements.push(el("label",{key:"gbt-attribute-"+attArr[i].value,className:"attribute-label"},el("input",{type:"checkbox",key:"attribute-checkbox-"+attArr[i].value,value:attArr[i].value,checked:_isChecked(attArr[i].value,attributes.queryAttributesOptionsSelected),onChange:function(evt){if(!0===evt.target.checked){var qCS=attributes.queryAttributesOptionsSelected;-1==qCS.indexOf(evt.target.value)&&qCS.push(evt.target.value),props.setAttributes({queryAttributesOptionsSelected:qCS})}else{var _qCS2=attributes.queryAttributesOptionsSelected,_index3=_qCS2.indexOf(evt.target.value);-1<_index3&&_qCS2.splice(_index3,1),props.setAttributes({queryAttributesOptionsSelected:_qCS2})}if(0<attributes.queryAttributesOptionsSelected.length){var query=getQuery("?per_page="+attributes.limit+"&attribute="+attributes.queryAttributesSelectedSlug+"&attribute_term="+attributes.queryAttributesOptionsSelected.join(","));query+=_getQueryOrder(),props.setAttributes({queryProducts:query})}else props.setAttributes({queryProducts:""})}}),attArr[i].label,el("sup",{key:"gbt-attribute-count"},attArr[i].count)));return attributeElements}()),"filter_by"===attributes.queryDisplayType&&""!=attributes.queryFilterSelected&&renderOrderby(),"all_products"===attributes.queryDisplayType&&renderOrderby(),"specific"!==attributes.queryDisplayType&&el(RangeControl,{key:"gbt-product-carousel-number-of-products",value:attributes.limit,allowReset:!1,initialPosition:10,min:2,max:20,label:i18n.__("Number of Products"),onChange:function(value){var old_limit,limit,newQ,old_value=attributes.limit;props.setAttributes({limit:value}),old_limit=old_value,limit=value,newQ=attributes.queryProducts.replace("per_page="+old_limit,"per_page="+limit),props.setAttributes({queryProducts:newQ})}}),el("button",{key:"gbt-product-carousel-load-button",className:"render-results components-button is-button is-default is-primary is-large "+(!0===attributes.isLoading?"is-busy":""),disabled:0==attributes.queryProducts.length||attributes.queryProducts===attributes.queryProductsLast,onClick:function(e){props.setAttributes({isLoading:!0}),props.setAttributes({querySearchString:""}),props.setAttributes({querySearchResults:[]}),getProducts()}},!1===attributes.isLoading?i18n.__("Update"):i18n.__("Updating")),el("hr",{key:"gbt-product-carousel-hr"}),el(RangeControl,{key:"gbt-product-carousel-columns",value:attributes.columns,allowReset:!1,initialPosition:3,min:2,max:6,label:i18n.__("Columns"),onChange:function(newColumns){props.setAttributes({columns:newColumns})}}),el(RangeControl,{key:"gbt-product-carousel-space-between",value:attributes.spaceBetween,allowReset:!1,initialPosition:30,min:0,max:50,label:i18n.__("Space Between Products"),onChange:function(newSpace){props.setAttributes({spaceBetween:newSpace})}}))),el("div",{key:"gbt_18_product_carousel_main_wrapper",className:"gbt_18_product_carousel"},attributes.result.length<1&&!1===attributes.doneFirstLoad&&getProducts(),function(){var idx,products=attributes.result,productElements=[],wrapper=[];if(0<products.length){for(var class_prefix="gbt_18_carousel_product",i=0;i<products.length;i++){var img="";img=products[i].images.length&&void 0!==products[i].images[0]&&""!=products[i].images[0].src?products[i].images[0].src:getbowtied_pbw.woo_placeholder_image,productElements.push(el("li",{key:class_prefix+products[i].id,className:class_prefix+(idx=i,attributes.selectedSlide<=idx&&idx<attributes.selectedSlide+attributes.columns?" is-visible":""),style:{width:100/products.length+"%",paddingRight:attributes.spaceBetween/2+"px",paddingLeft:attributes.spaceBetween/2+"px"}},el("div",{key:class_prefix+"_content_wrapper"+i,className:class_prefix+"_content_wrapper"},el("div",{key:class_prefix+"_thumbnail"+i,className:class_prefix+"_thumbnail",style:{backgroundImage:"url("+img+")"}}),el("h4",{key:class_prefix+"_title"+i,className:class_prefix+"_title"},products[i].name),el("span",{key:class_prefix+"_price"+i,className:class_prefix+"_price",dangerouslySetInnerHTML:{__html:products[i].price_html}}),el("button",{key:class_prefix+"_button"+i,className:class_prefix+"_button"},i18n.__("Add To Cart")))))}wrapper.push(el("div",{key:"gbt_18_product_carousel_wrapper",className:"gbt_18_product_carousel_wrapper"},el("div",{key:"gbt_18_product_carousel_scrollable_wrapper",className:"scrollable_wrapper"},el("ul",{key:"gbt_18_carousel_products gbt_18_carousel_slider",className:"gbt_18_carousel_products gbt_18_carousel_slider columns-"+attributes.columns,style:{width:100*productElements.length/attributes.columns+"%",marginLeft:-attributes.selectedSlide*(100/attributes.columns)+"%"}},productElements)),el("button",{key:"gbt_18_carousel_toggle-prev-button",className:"toggle-prev-button",disabled:0==attributes.selectedSlide,onClick:function(){var idx=attributes.selectedSlide;0<=idx-1?props.setAttributes({selectedSlide:idx-1}):props.setAttributes({selectedSlide:productElements.length-1})}},el(SVG,{key:"gbt_18_carousel_toggle-prev-button-svg",className:"gbt_18_carousel_products_placeholder_toggle toggle-prev",xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 1024 1024",width:"16",height:"16"},el(Path,{key:"gbt_18_carousel_toggle-prev-button-svg-path",d:"M427.699 171.705c9.999-9.996 10.001-26.205 0.005-36.204s-26.205-10.001-36.204-0.005l-307.2 307.107c-9.999 9.996-10.001 26.205-0.005 36.204l307.2 307.293c9.996 9.999 26.205 10.001 36.204 0.005s10.001-26.205 0.005-36.204l-289.101-289.188 289.095-289.008zM102.4 435.2c-14.138 0-25.6 11.462-25.6 25.6s11.462 25.6 25.6 25.6h819.2c14.138 0 25.6-11.462 25.6-25.6s-11.462-25.6-25.6-25.6h-819.2z"}))),el("button",{key:"gbt_18_carousel_toggle-next-button",className:"toggle-next-button",disabled:products.length-1<attributes.selectedSlide+attributes.columns,onClick:function(){var idx=attributes.selectedSlide;idx+1<productElements.length?props.setAttributes({selectedSlide:idx+1}):props.setAttributes({selectedSlide:0})}},el(SVG,{key:"gbt_18_carousel_toggle-next-button-svg",className:"gbt_18_carousel_products_placeholder_toggle toggle-next",xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 1024 1024",width:"16",height:"16"},el(Path,{key:"gbt_18_carousel_toggle-next-button-svg-path",d:"M596.301 749.895c-9.999 9.996-10.001 26.205-0.005 36.204s26.205 10.001 36.204 0.005l307.2-307.107c9.999-9.996 10.001-26.205 0.005-36.204l-307.2-307.293c-9.996-9.999-26.205-10.001-36.204-0.005s-10.001 26.205-0.005 36.204l289.101 289.188-289.095 289.008zM921.6 486.4c14.138 0 25.6-11.462 25.6-25.6s-11.462-25.6-25.6-25.6h-819.2c-14.138 0-25.6 11.462-25.6 25.6s11.462 25.6 25.6 25.6h819.2z"})))))}else{for(var _class_prefix="gbt_18_carousel_placeholder_product",j=0;j<=2;j++)productElements.push(el("li",{key:_class_prefix+"_item-"+j,className:_class_prefix+" item-"+j},el("div",{key:_class_prefix+"_content_wrapper"+j,className:_class_prefix+"_content_wrapper"},el("div",{key:_class_prefix+"_thumbnail"+j,className:_class_prefix+"_thumbnail"}),el("div",{key:_class_prefix+"_title"+j,className:_class_prefix+"_title"}),el("div",{key:_class_prefix+"_price"+j,className:_class_prefix+"_price"}),el("button",{key:_class_prefix+"_button"+j,className:_class_prefix+"_button"},i18n.__("Add To Cart")))));wrapper.push(el("div",{key:"gbt_18_product_carousel_placeholder_wrapper",className:"gbt_18_product_carousel_placeholder_wrapper"},el("ul",{key:"gbt_18_carousel_products_placeholder",className:"gbt_18_carousel_products_placeholder"},productElements),el("button",{key:"gbt_18_carousel_placeholder_toggle-prev-button",className:"toggle-prev-button"},el(SVG,{key:"gbt_18_carousel_placeholder_toggle-prev-button-svg",className:"gbt_18_carousel_products_placeholder_toggle toggle-prev",xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24"},el(Path,{key:"gbt_18_carousel_placeholder_toggle-prev-button-svg-path",d:"M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z"}))),el("button",{key:"gbt_18_carousel_placeholder_toggle-next-button",className:"toggle-next-button"},el(SVG,{key:"gbt_18_carousel_placeholder_toggle-next-button-svg",className:"gbt_18_carousel_products_placeholder_toggle toggle-next",xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24"},el(Path,{key:"gbt_18_carousel_placeholder_toggle-next-button-svg-path",d:"M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z"})))))}return wrapper}())]},save:function(){return null}})}(window.wp.blocks,window.wp.components,window.wp.editor,window.wp.i18n,window.wp.element,jQuery);