<?php
$xstore_branding_settings = get_option( 'xstore_white_label_branding_settings', array() );
?>
<script type="text/template" id="tmpl-et-studio-logo">
    <?php
    if ( isset( $xstore_branding_settings['control_panel']['logo'] ) && ! empty( $xstore_branding_settings['control_panel']['logo'] ) ) : ?>
        <span class="et-studio-logo-img et-studio-icon">
        <img src="<?php echo esc_url( $xstore_branding_settings['control_panel']['logo'] ); ?>" alt="panel-logo">
    </span>
    <?php else: ?>
        <span class="et-studio-logo-img or et-studio-icon main-studio-logo">
            <svg width="248" height="34" viewBox="0 0 248 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19.9396 11.2769L27.6512 0.109329H24.6481C24.5357 0.109329 24.4362 0.1286 24.3495 0.176785C24.3077 0.19284 24.2692 0.218541 24.2339 0.247436C24.1182 0.340573 24.0154 0.459429 23.9159 0.613591L18.6966 8.36381L18.1859 9.11857C18.0059 9.38783 18.1669 9.15128 17.8004 9.67137L17.4278 10.2372L16.6828 11.2769L24.6481 23.3631C24.6931 23.3695 24.7413 23.3727 24.7927 23.3727H27.9114L19.9396 11.2769Z" fill="var(--et_xstudio-white-color, #fff)"></path>
<path d="M10.6611 11.4244L2.98226 0.108948H6.11539C6.34279 0.108948 6.51043 0.1469 6.61865 0.222492C6.7267 0.298396 6.82424 0.406608 6.91097 0.547126L12.9826 9.86588C13.0581 9.63843 13.1719 9.38971 13.3236 9.11904L19.0545 0.612366C19.1517 0.46087 19.2571 0.339171 19.371 0.246957C19.4845 0.155056 19.6225 0.108948 19.785 0.108948H22.7883L15.0769 11.2782L23.048 23.3729H19.9309C19.6928 23.3729 19.5061 23.3108 19.371 23.1862C19.2355 23.0621 19.1248 22.924 19.0382 22.7722L12.8039 13.0153C12.7282 13.2427 12.6308 13.4591 12.5118 13.6646L6.44017 22.7722C6.34278 22.924 6.23159 23.0621 6.10739 23.1862C5.98271 23.3108 5.80706 23.3729 5.57965 23.3729H2.65747L10.6611 11.4244Z" fill="var(--et_xstudio-white-color, #fff)"></path>
<path d="M42.1201 3.92933C42.0251 4.08826 41.924 4.20736 41.8182 4.28702C41.7118 4.36629 41.5739 4.40613 41.4047 4.40613C41.2239 4.40613 41.0148 4.31613 40.7766 4.13575C40.5384 3.95575 40.2358 3.75698 39.8704 3.53983C39.5043 3.32269 39.0647 3.12393 38.5507 2.94354C38.0367 2.76316 37.4141 2.67316 36.6825 2.67316C35.9932 2.67316 35.3835 2.76623 34.8542 2.95158C34.3234 3.13695 33.8815 3.38856 33.5264 3.70681C33.171 4.02469 32.9037 4.39808 32.7233 4.8274C32.5429 5.25672 32.4534 5.7205 32.4534 6.21875C32.4534 6.85487 32.6096 7.38223 32.9221 7.80082C33.2346 8.21942 33.6482 8.57747 34.1626 8.87394C34.6765 9.17073 35.2594 9.42807 35.9112 9.64526C36.563 9.86236 37.231 10.0879 37.9142 10.3208C38.5982 10.5541 39.2661 10.8163 39.9179 11.1078C40.5697 11.3997 41.1527 11.7677 41.6666 12.2127C42.1813 12.6581 42.5942 13.2042 42.9074 13.8503C43.2199 14.4971 43.3762 15.2922 43.3762 16.2355C43.3762 17.232 43.2061 18.1672 42.8676 19.0415C42.5283 19.9163 42.0327 20.6768 41.3809 21.3233C40.729 21.9697 39.9286 22.4788 38.9797 22.8494C38.0306 23.2206 36.9529 23.4059 35.7443 23.4059C34.2713 23.4059 32.9274 23.1386 31.7138 22.6032C30.5002 22.0678 29.4642 21.3448 28.6056 20.4329L29.496 18.9699C29.5807 18.8535 29.684 18.7554 29.8059 18.6758C29.9276 18.5965 30.0628 18.5567 30.2114 18.5567C30.4339 18.5567 30.6882 18.6758 30.9747 18.9143C31.2607 19.1529 31.6185 19.4153 32.0478 19.7014C32.4771 19.9875 32.9964 20.2498 33.6061 20.4884C34.2154 20.727 34.96 20.8461 35.84 20.8461C36.5707 20.8461 37.2233 20.7458 37.7955 20.544C38.3676 20.3429 38.8524 20.0591 39.25 19.6933C39.6475 19.328 39.9524 18.8907 40.1646 18.3816C40.3767 17.8731 40.4824 17.3062 40.4824 16.6805C40.4824 15.9915 40.3262 15.4274 40.0136 14.9874C39.7004 14.5477 39.2899 14.1793 38.7812 13.8821C38.2727 13.5857 37.6921 13.3337 37.0402 13.1268C36.3884 12.9204 35.7205 12.7082 35.0373 12.4911C34.3533 12.2739 33.6854 12.0219 33.0335 11.7359C32.3817 11.4498 31.8015 11.0787 31.2926 10.6229C30.7839 10.1672 30.373 9.59733 30.0605 8.91371C29.7476 8.23016 29.5913 7.38491 29.5913 6.37768C29.5913 5.57228 29.7476 4.79332 30.0605 4.04039C30.373 3.28784 30.826 2.62031 31.4197 2.03704C32.0133 1.45454 32.7475 0.987692 33.6218 0.638034C34.4965 0.288378 35.4999 0.113358 36.6351 0.113358C37.9065 0.113358 39.0677 0.314803 40.117 0.717693C41.1664 1.12058 42.0825 1.70347 42.8676 2.46636L42.1201 3.92933Z" fill="var(--et_xstudio-white-color, #fff)"></path>
<path d="M62.8205 0.367645V2.95924H55.4598V23.1516H52.3753V2.95924H44.9816V0.367645H62.8205Z" fill="var(--et_xstudio-white-color, #fff)"></path>
<path d="M85.668 11.7677C85.668 13.4742 85.3982 15.0406 84.8578 16.4661C84.3166 17.8914 83.5543 19.1185 82.5683 20.1468C81.5824 21.1747 80.3973 21.9725 79.0145 22.5396C77.631 23.1068 76.1021 23.3902 74.4278 23.3902C72.7526 23.3902 71.2261 23.1068 69.8482 22.5396C68.4703 21.9725 67.2884 21.1747 66.3026 20.1468C65.3169 19.1185 64.5539 17.8914 64.0131 16.4661C63.4732 15.0406 63.2028 13.4742 63.2028 11.7677C63.2028 10.0611 63.4732 8.49519 64.0131 7.06933C64.5539 5.6439 65.3169 4.41417 66.3026 3.38052C67.2884 2.34726 68.4703 1.54415 69.8482 0.97199C71.2261 0.39944 72.7526 0.113358 74.4278 0.113358C76.1021 0.113358 77.631 0.39944 79.0145 0.97199C80.3973 1.54415 81.5824 2.34726 82.5683 3.38052C83.5543 4.41417 84.3166 5.6439 84.8578 7.06933C85.3982 8.49519 85.668 10.0611 85.668 11.7677ZM82.5048 11.7677C82.5048 10.3686 82.3142 9.11254 81.9315 7.99957C81.5503 6.88665 81.0099 5.94607 80.3102 5.17744C79.6106 4.4088 78.762 3.81788 77.7666 3.40465C76.7701 2.99104 75.6571 2.78461 74.4278 2.78461C73.2084 2.78461 72.1009 2.99104 71.1044 3.40465C70.1079 3.81788 69.2577 4.4088 68.5529 5.17744C67.8475 5.94607 67.3044 6.88665 66.923 7.99957C66.5416 9.11254 66.3508 10.3686 66.3508 11.7677C66.3508 13.1667 66.5416 14.4202 66.923 15.5278C67.3044 16.6357 67.8475 17.5736 68.5529 18.3422C69.2577 19.1108 70.1079 19.6991 71.1044 20.1069C72.1009 20.5153 73.2084 20.7189 74.4278 20.7189C75.6571 20.7189 76.7701 20.5153 77.7666 20.1069C78.762 19.6991 79.6106 19.1108 80.3102 18.3422C81.0099 17.5736 81.5503 16.6357 81.9315 15.5278C82.3142 14.4202 82.5048 13.1667 82.5048 11.7677Z" fill="var(--et_xstudio-white-color, #fff)"></path>
<path d="M93.2682 13.6439V23.1516H90.1991V0.367645H96.6385C98.0801 0.367645 99.3256 0.513559 100.375 0.805005C101.424 1.09645 102.29 1.51811 102.975 2.06883C103.658 2.62031 104.164 3.28515 104.493 4.06451C104.821 4.84347 104.986 5.71551 104.986 6.67984C104.986 7.48563 104.859 8.23776 104.605 8.93747C104.349 9.63717 103.981 10.2653 103.499 10.8217C103.017 11.3782 102.428 11.8527 101.734 12.2445C101.04 12.637 100.253 12.9338 99.3734 13.1349C99.7546 13.3574 100.094 13.681 100.392 14.105L107.036 23.1516H104.302C103.74 23.1516 103.327 22.9344 103.062 22.4998L97.1475 14.3592C96.9671 14.105 96.771 13.9219 96.5593 13.8108C96.3467 13.6994 96.029 13.6439 95.6055 13.6439H93.2682ZM93.2682 11.4019H96.4957C97.3961 11.4019 98.1891 11.2935 98.8723 11.076C99.5562 10.8588 100.129 10.5513 100.59 10.1538C101.05 9.75631 101.398 9.28218 101.632 8.73064C101.864 8.17996 101.981 7.57026 101.981 6.90235C101.981 5.54585 101.534 4.52293 100.637 3.83395C99.7413 3.14498 98.4087 2.8003 96.6385 2.8003H93.2682V11.4019Z" fill="var(--et_xstudio-white-color, #fff)"></path>
<path d="M124.399 0.367645V2.87997H113.461V10.4479H122.317V12.8645H113.461V20.6396H124.399V23.1516H110.36V0.367645H124.399Z" fill="var(--et_xstudio-white-color, #fff)"></path>
<path opacity="0.7" d="M147.694 2.98619C147.6 3.16621 147.463 3.25622 147.285 3.25622C147.149 3.25622 146.97 3.16091 146.75 2.97031C146.54 2.76911 146.252 2.55203 145.885 2.31906C145.518 2.07551 145.057 1.85313 144.501 1.65194C143.955 1.45074 143.279 1.35014 142.472 1.35014C141.664 1.35014 140.951 1.46662 140.332 1.69959C139.724 1.93255 139.21 2.25023 138.791 2.65263C138.382 3.05502 138.067 3.52095 137.847 4.05042C137.637 4.57988 137.532 5.13582 137.532 5.71823C137.532 6.48067 137.69 7.11073 138.004 7.60843C138.329 8.10613 138.754 8.5297 139.278 8.87915C139.803 9.22859 140.395 9.52509 141.056 9.76865C141.727 10.0016 142.414 10.2346 143.117 10.4675C143.819 10.7005 144.501 10.9599 145.161 11.2459C145.833 11.5212 146.43 11.8706 146.955 12.2942C147.479 12.7178 147.898 13.2419 148.213 13.8667C148.538 14.4809 148.701 15.2486 148.701 16.1699C148.701 17.1123 148.538 18.0018 148.213 18.8384C147.898 19.6644 147.437 20.3844 146.829 20.9986C146.221 21.6128 145.476 22.0999 144.595 22.4599C143.714 22.8094 142.708 22.9841 141.575 22.9841C140.107 22.9841 138.843 22.7247 137.784 22.2058C136.725 21.6763 135.797 20.9563 135 20.0456L135.44 19.3467C135.566 19.1878 135.713 19.1084 135.881 19.1084C135.975 19.1084 136.096 19.172 136.243 19.299C136.389 19.4261 136.568 19.5849 136.777 19.7756C136.987 19.9556 137.239 20.1568 137.532 20.3791C137.826 20.5909 138.167 20.7921 138.555 20.9827C138.943 21.1628 139.389 21.3163 139.892 21.4434C140.395 21.5704 140.967 21.634 141.607 21.634C142.487 21.634 143.274 21.5016 143.966 21.2369C144.658 20.9616 145.24 20.5909 145.712 20.125C146.194 19.6591 146.561 19.1084 146.813 18.4731C147.065 17.8271 147.191 17.1388 147.191 16.4082C147.191 15.614 147.028 14.9627 146.703 14.4544C146.388 13.9355 145.969 13.5067 145.445 13.1678C144.92 12.8184 144.323 12.5272 143.651 12.2942C142.991 12.0612 142.309 11.8336 141.607 11.6112C140.904 11.3888 140.217 11.14 139.546 10.8646C138.885 10.5893 138.293 10.2399 137.768 9.8163C137.244 9.38214 136.819 8.84738 136.494 8.21202C136.18 7.56607 136.022 6.76128 136.022 5.79765C136.022 5.04581 136.164 4.32044 136.447 3.62155C136.73 2.92265 137.144 2.30847 137.69 1.77901C138.235 1.23895 138.906 0.810085 139.703 0.492403C140.511 0.164134 141.428 0 142.456 0C143.609 0 144.642 0.185313 145.555 0.55594C146.477 0.926568 147.316 1.4931 148.071 2.25553L147.694 2.98619ZM167.905 0.254144V1.63605H160.088V22.73H158.483V1.63605H150.618V0.254144H167.905ZM180 21.5704C181.07 21.5704 182.024 21.3851 182.863 21.0145C183.713 20.6333 184.431 20.1091 185.018 19.442C185.605 18.7749 186.051 17.9913 186.355 17.0912C186.67 16.1805 186.827 15.201 186.827 14.1526V0.254144H188.432V14.1526C188.432 15.3916 188.238 16.5511 187.85 17.6312C187.462 18.7007 186.901 19.6379 186.166 20.4427C185.443 21.2369 184.557 21.8616 183.508 22.317C182.47 22.7723 181.301 23 180 23C178.7 23 177.526 22.7723 176.477 22.317C175.439 21.8616 174.553 21.2369 173.819 20.4427C173.095 19.6379 172.539 18.7007 172.151 17.6312C171.763 16.5511 171.569 15.3916 171.569 14.1526V0.254144H173.189V14.1367C173.189 15.1851 173.341 16.1646 173.646 17.0753C173.96 17.9754 174.406 18.759 174.983 19.4261C175.57 20.0932 176.283 20.6174 177.122 20.9986C177.971 21.3798 178.931 21.5704 180 21.5704ZM213.58 11.4841C213.58 13.2208 213.323 14.7827 212.809 16.1699C212.296 17.5571 211.572 18.7378 210.639 19.712C209.705 20.6862 208.589 21.4328 207.288 21.9517C205.988 22.4705 204.546 22.73 202.963 22.73H194.846V0.254144H202.963C204.546 0.254144 205.988 0.513583 207.288 1.03246C208.589 1.55134 209.705 2.29788 210.639 3.2721C211.572 4.24632 212.296 5.42703 212.809 6.81423C213.323 8.20143 213.58 9.75806 213.58 11.4841ZM211.913 11.4841C211.913 9.9169 211.698 8.51911 211.268 7.29075C210.838 6.06239 210.23 5.02463 209.443 4.17749C208.667 3.33034 207.729 2.68439 206.628 2.23964C205.527 1.79489 204.305 1.57252 202.963 1.57252H196.466V21.4116H202.963C204.305 21.4116 205.527 21.1892 206.628 20.7445C207.729 20.2997 208.667 19.6538 209.443 18.8066C210.23 17.9595 210.838 16.9217 211.268 15.6934C211.698 14.465 211.913 13.0619 211.913 11.4841ZM220.95 22.73H219.33V0.254144H220.95V22.73ZM248 11.4841C248 13.2208 247.743 14.7986 247.229 16.2175C246.715 17.6259 245.992 18.8331 245.059 19.8391C244.125 20.8345 243.008 21.6075 241.708 22.1581C240.408 22.6982 238.966 22.9682 237.382 22.9682C235.82 22.9682 234.389 22.6982 233.088 22.1581C231.788 21.6075 230.671 20.8345 229.738 19.8391C228.804 18.8331 228.076 17.6259 227.551 16.2175C227.037 14.7986 226.781 13.2208 226.781 11.4841C226.781 9.75806 227.037 8.19084 227.551 6.78246C228.076 5.36349 228.804 4.15631 229.738 3.16091C230.671 2.15493 231.788 1.37661 233.088 0.825969C234.389 0.275322 235.82 0 237.382 0C238.966 0 240.408 0.275322 241.708 0.825969C243.008 1.36602 244.125 2.13904 245.059 3.14503C245.992 4.15102 246.715 5.36349 247.229 6.78246C247.743 8.19084 248 9.75806 248 11.4841ZM246.333 11.4841C246.333 9.9169 246.118 8.50852 245.688 7.25898C245.258 6.00944 244.65 4.95051 243.863 4.08218C243.087 3.21386 242.149 2.55203 241.047 2.09669C239.946 1.63076 238.725 1.39779 237.382 1.39779C236.061 1.39779 234.85 1.63076 233.749 2.09669C232.658 2.55203 231.714 3.21386 230.917 4.08218C230.131 4.95051 229.518 6.00944 229.077 7.25898C228.647 8.50852 228.432 9.9169 228.432 11.4841C228.432 13.0619 228.647 14.4756 229.077 15.7251C229.518 16.9641 230.131 18.0177 230.917 18.886C231.714 19.7544 232.658 20.4162 233.749 20.8715C234.85 21.3269 236.061 21.5546 237.382 21.5546C238.725 21.5546 239.946 21.3269 241.047 20.8715C242.149 20.4162 243.087 19.7544 243.863 18.886C244.65 18.0177 245.258 16.9641 245.688 15.7251C246.118 14.4756 246.333 13.0619 246.333 11.4841Z" fill="var(--et_xstudio-white-color, #fff)"></path>
</svg>
        </span>
        <span class="et-studio-logo-img or et-studio-icon templates-studio-logo">
            <svg width="272" height="29" viewBox="0 0 272 29" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M19.9397 11.2769L27.6513 0.109375H24.6482C24.5358 0.109375 24.4363 0.128645 24.3496 0.176831C24.3078 0.192886 24.2692 0.218586 24.234 0.247482C24.1183 0.340618 24.0155 0.459475 23.916 0.613637L18.6967 8.36385L18.186 9.11862C18.006 9.38788 18.167 9.15133 17.8005 9.67142L17.4279 10.2372L16.6829 11.2769L24.6482 23.3631C24.6932 23.3696 24.7414 23.3728 24.7928 23.3728H27.9115L19.9397 11.2769Z" fill="var(--et_xstudio-white-color, #fff)"/>
                <path d="M10.6611 11.4244L2.98226 0.108887H6.11539C6.34279 0.108887 6.51043 0.146839 6.61865 0.222431C6.7267 0.298335 6.82424 0.406547 6.91097 0.547065L12.9826 9.86582C13.0581 9.63837 13.1719 9.38965 13.3236 9.11898L19.0545 0.612305C19.1517 0.460809 19.2571 0.33911 19.371 0.246896C19.4845 0.154995 19.6225 0.108887 19.785 0.108887H22.7883L15.0769 11.2782L23.048 23.3728H19.9309C19.6928 23.3728 19.5061 23.3107 19.371 23.1862C19.2355 23.062 19.1248 22.9239 19.0382 22.7722L12.8039 13.0152C12.7282 13.2426 12.6308 13.4591 12.5118 13.6645L6.44017 22.7722C6.34278 22.9239 6.23159 23.062 6.10739 23.1862C5.98271 23.3107 5.80706 23.3728 5.57965 23.3728H2.65747L10.6611 11.4244Z" fill="var(--et_xstudio-white-color, #fff)"/>
                <path d="M42.1199 3.92925C42.0249 4.08818 41.9238 4.20729 41.8181 4.28695C41.7117 4.36622 41.5738 4.40605 41.4045 4.40605C41.2238 4.40605 41.0146 4.31605 40.7764 4.13567C40.5382 3.95567 40.2356 3.75691 39.8703 3.53976C39.5042 3.32262 39.0646 3.12385 38.5506 2.94347C38.0366 2.76309 37.4139 2.67309 36.6824 2.67309C35.993 2.67309 35.3834 2.76615 34.8541 2.95151C34.3233 3.13687 33.8814 3.38848 33.5263 3.70673C33.1709 4.02461 32.9036 4.39801 32.7232 4.82733C32.5428 5.25664 32.4533 5.72042 32.4533 6.21867C32.4533 6.8548 32.6095 7.38215 32.922 7.80074C33.2345 8.21934 33.6481 8.57739 34.1625 8.87387C34.6764 9.17066 35.2593 9.428 35.9111 9.64518C36.5629 9.86228 37.2309 10.0879 37.9141 10.3207C38.598 10.554 39.266 10.8163 39.9178 11.1077C40.5696 11.3996 41.1525 11.7676 41.6664 12.2126C42.1812 12.658 42.5941 13.2042 42.9073 13.8502C43.2198 14.4971 43.376 15.2921 43.376 16.2354C43.376 17.2319 43.206 18.1671 42.8675 19.0414C42.5282 19.9162 42.0326 20.6767 41.3808 21.3232C40.7289 21.9696 39.9285 22.4787 38.9795 22.8494C38.0305 23.2205 36.9528 23.4058 35.7442 23.4058C34.2712 23.4058 32.9273 23.1385 31.7137 22.6031C30.5 22.0677 29.4641 21.3447 28.6055 20.4328L29.4958 18.9698C29.5806 18.8534 29.6839 18.7554 29.8057 18.6757C29.9275 18.5965 30.0627 18.5566 30.2113 18.5566C30.4338 18.5566 30.6881 18.6757 30.9745 18.9143C31.2606 19.1529 31.6183 19.4152 32.0477 19.7014C32.4769 19.9874 32.9962 20.2498 33.606 20.4884C34.2153 20.7269 34.9598 20.846 35.8399 20.846C36.5706 20.846 37.2232 20.7457 37.7953 20.5439C38.3675 20.3428 38.8523 20.059 39.2499 19.6933C39.6474 19.3279 39.9523 18.8906 40.1644 18.3816C40.3766 17.873 40.4823 17.3062 40.4823 16.6804C40.4823 15.9915 40.3261 15.4273 40.0135 14.9873C39.7003 14.5477 39.2897 14.1792 38.7811 13.882C38.2725 13.5856 37.692 13.3336 37.0401 13.1268C36.3883 12.9203 35.7204 12.7082 35.0372 12.4911C34.3531 12.2739 33.6853 12.0219 33.0334 11.7358C32.3816 11.4497 31.8014 11.0786 31.2924 10.6229C30.7838 10.1672 30.3729 9.59726 30.0604 8.91363C29.7475 8.23009 29.5912 7.38483 29.5912 6.37761C29.5912 5.57221 29.7475 4.79324 30.0604 4.04031C30.3729 3.28776 30.8259 2.62024 31.4196 2.03697C32.0132 1.45446 32.7474 0.987616 33.6217 0.637958C34.4964 0.288301 35.4998 0.113281 36.6349 0.113281C37.9064 0.113281 39.0676 0.314726 40.1169 0.717616C41.1663 1.12051 42.0824 1.70339 42.8675 2.46628L42.1199 3.92925Z" fill="var(--et_xstudio-white-color, #fff)"/>
                <path d="M62.8206 0.367676V2.95927H55.4599V23.1517H52.3754V2.95927H44.9817V0.367676H62.8206Z" fill="var(--et_xstudio-white-color, #fff)"/>
                <path d="M85.6679 11.7676C85.6679 13.4741 85.3981 15.0405 84.8577 16.466C84.3165 17.8913 83.5541 19.1184 82.5682 20.1467C81.5823 21.1746 80.3972 21.9724 79.0144 22.5395C77.6309 23.1068 76.102 23.3901 74.4277 23.3901C72.7525 23.3901 71.226 23.1068 69.8481 22.5395C68.4701 21.9724 67.2882 21.1746 66.3025 20.1467C65.3167 19.1184 64.5538 17.8913 64.013 16.466C63.4731 15.0405 63.2026 13.4741 63.2026 11.7676C63.2026 10.061 63.4731 8.49511 64.013 7.06926C64.5538 5.64383 65.3167 4.41409 66.3025 3.38044C67.2882 2.34718 68.4701 1.54408 69.8481 0.971913C71.226 0.399364 72.7525 0.113281 74.4277 0.113281C76.102 0.113281 77.6309 0.399364 79.0144 0.971913C80.3972 1.54408 81.5823 2.34718 82.5682 3.38044C83.5541 4.41409 84.3165 5.64383 84.8577 7.06926C85.3981 8.49511 85.6679 10.061 85.6679 11.7676ZM82.5047 11.7676C82.5047 10.3686 82.3141 9.11246 81.9313 7.99949C81.5502 6.88658 81.0098 5.94599 80.3101 5.17736C79.6105 4.40873 78.7619 3.8178 77.7665 3.40457C76.77 2.99096 75.657 2.78453 74.4277 2.78453C73.2083 2.78453 72.1007 2.99096 71.1042 3.40457C70.1078 3.8178 69.2575 4.40873 68.5528 5.17736C67.8474 5.94599 67.3043 6.88658 66.9229 7.99949C66.5415 9.11246 66.3507 10.3686 66.3507 11.7676C66.3507 13.1666 66.5415 14.4201 66.9229 15.5277C67.3043 16.6356 67.8474 17.5735 68.5528 18.3421C69.2575 19.1107 70.1078 19.699 71.1042 20.1069C72.1007 20.5152 73.2083 20.7189 74.4277 20.7189C75.657 20.7189 76.77 20.5152 77.7665 20.1069C78.7619 19.699 79.6105 19.1107 80.3101 18.3421C81.0098 17.5735 81.5502 16.6356 81.9313 15.5277C82.3141 14.4201 82.5047 13.1666 82.5047 11.7676Z" fill="var(--et_xstudio-white-color, #fff)"/>
                <path d="M93.2683 13.6439V23.1517H90.1992V0.367676H96.6386C98.0802 0.367676 99.3257 0.513589 100.375 0.805036C101.425 1.09648 102.29 1.51814 102.975 2.06886C103.658 2.62034 104.164 3.28518 104.493 4.06454C104.822 4.8435 104.986 5.71554 104.986 6.67987C104.986 7.48566 104.859 8.23779 104.605 8.9375C104.349 9.6372 103.982 10.2653 103.499 10.8218C103.017 11.3782 102.429 11.8527 101.734 12.2445C101.04 12.637 100.254 12.9338 99.3736 13.1349C99.7547 13.3575 100.094 13.6811 100.392 14.105L107.037 23.1517H104.302C103.74 23.1517 103.327 22.9345 103.062 22.4998L97.1476 14.3593C96.9672 14.105 96.7711 13.9219 96.5594 13.8109C96.3468 13.6994 96.0292 13.6439 95.6056 13.6439H93.2683ZM93.2683 11.402H96.4958C97.3963 11.402 98.1892 11.2936 98.8724 11.0761C99.5563 10.8589 100.129 10.5513 100.59 10.1538C101.05 9.75634 101.398 9.28221 101.632 8.73067C101.865 8.17999 101.981 7.57029 101.981 6.90238C101.981 5.54588 101.534 4.52296 100.637 3.83398C99.7414 3.14502 98.4088 2.80033 96.6386 2.80033H93.2683V11.402Z" fill="var(--et_xstudio-white-color, #fff)"/>
                <path d="M124.399 0.367676V2.88H113.461V10.448H122.317V12.8646H113.461V20.6397H124.399V23.1517H110.36V0.367676H124.399Z" fill="var(--et_xstudio-white-color, #fff)"/>
                <path opacity="0.7" d="M152.63 0.64195V2.03819H144.657V23.3509H143.021V2.03819H135V0.64195H152.63ZM158.374 7.12562C159.272 7.12562 160.101 7.28076 160.86 7.59104C161.63 7.90131 162.293 8.35603 162.849 8.95518C163.416 9.54363 163.855 10.2712 164.165 11.1378C164.486 12.0044 164.646 12.9994 164.646 14.1229C164.646 14.3582 164.609 14.5187 164.534 14.6043C164.47 14.6899 164.363 14.7327 164.213 14.7327H152.679V15.0376C152.679 16.2359 152.818 17.2898 153.096 18.1992C153.374 19.1087 153.77 19.8736 154.283 20.4942C154.796 21.104 155.417 21.5641 156.144 21.8744C156.871 22.1847 157.684 22.3398 158.582 22.3398C159.384 22.3398 160.08 22.2542 160.668 22.083C161.256 21.9011 161.748 21.7032 162.144 21.4892C162.55 21.2645 162.871 21.0666 163.106 20.8954C163.341 20.7135 163.512 20.6226 163.619 20.6226C163.758 20.6226 163.865 20.6761 163.94 20.7831L164.357 21.2966C164.101 21.6176 163.758 21.9172 163.331 22.1954C162.914 22.4735 162.443 22.7143 161.919 22.9175C161.406 23.1101 160.849 23.2653 160.251 23.383C159.662 23.5006 159.069 23.5595 158.47 23.5595C157.379 23.5595 156.385 23.3723 155.486 22.9978C154.588 22.6126 153.818 22.0563 153.176 21.3287C152.535 20.6012 152.037 19.7132 151.684 18.6646C151.342 17.6054 151.171 16.3964 151.171 15.0376C151.171 13.8928 151.332 12.839 151.652 11.876C151.984 10.9024 152.454 10.0679 153.064 9.37244C153.684 8.6663 154.438 8.11529 155.326 7.71943C156.224 7.32356 157.24 7.12562 158.374 7.12562ZM158.39 8.26508C157.566 8.26508 156.828 8.39347 156.176 8.65025C155.524 8.90703 154.957 9.27615 154.476 9.75761C154.005 10.2391 153.62 10.8168 153.321 11.4909C153.032 12.1649 152.839 12.9192 152.743 13.7537H163.266C163.266 12.8978 163.149 12.1328 162.914 11.4588C162.678 10.774 162.347 10.1963 161.919 9.72551C161.491 9.25475 160.978 8.89633 160.379 8.65025C159.78 8.39347 159.117 8.26508 158.39 8.26508ZM168.744 23.3509V7.3824H169.578C169.857 7.3824 170.017 7.51614 170.06 7.78362L170.204 10.0946C170.514 9.65597 170.846 9.25475 171.199 8.89098C171.552 8.52721 171.926 8.21694 172.322 7.96016C172.728 7.69268 173.156 7.4894 173.605 7.35031C174.065 7.20052 174.546 7.12562 175.049 7.12562C176.214 7.12562 177.145 7.468 177.84 8.15274C178.535 8.82679 179.006 9.76831 179.252 10.9773C179.444 10.314 179.711 9.74156 180.054 9.2601C180.407 8.77864 180.808 8.38277 181.257 8.0725C181.706 7.75152 182.192 7.51614 182.717 7.36635C183.251 7.20587 183.797 7.12562 184.353 7.12562C185.144 7.12562 185.855 7.25936 186.486 7.52684C187.117 7.78362 187.652 8.16879 188.09 8.68235C188.54 9.19591 188.882 9.82716 189.117 10.5761C189.352 11.325 189.47 12.181 189.47 13.1439V23.3509H187.93V13.1439C187.93 11.5818 187.593 10.3942 186.919 9.58108C186.246 8.75724 185.283 8.34533 184.032 8.34533C183.476 8.34533 182.941 8.44697 182.428 8.65025C181.925 8.85353 181.476 9.15846 181.08 9.56503C180.695 9.9609 180.385 10.4584 180.15 11.0576C179.925 11.6567 179.813 12.3522 179.813 13.1439V23.3509H178.289V13.1439C178.289 11.5925 177.979 10.4049 177.359 9.58108C176.738 8.75724 175.835 8.34533 174.648 8.34533C173.781 8.34533 172.979 8.60745 172.241 9.13171C171.503 9.64527 170.846 10.3621 170.268 11.2822V23.3509H168.744ZM194.279 29V7.3824H195.113C195.252 7.3824 195.365 7.4145 195.45 7.4787C195.536 7.53219 195.584 7.63383 195.595 7.78362L195.739 10.2551C196.445 9.2922 197.268 8.52721 198.209 7.96016C199.161 7.3931 200.225 7.10958 201.402 7.10958C203.369 7.10958 204.899 7.78897 205.99 9.14776C207.08 10.5066 207.626 12.5447 207.626 15.2623C207.626 16.4285 207.471 17.5198 207.161 18.5363C206.861 19.542 206.417 20.4193 205.829 21.1682C205.241 21.9065 204.514 22.4896 203.647 22.9175C202.792 23.3455 201.803 23.5595 200.68 23.5595C199.589 23.5595 198.648 23.3616 197.857 22.9657C197.065 22.5698 196.381 21.9814 195.803 21.2003V29H194.279ZM200.969 8.34533C199.91 8.34533 198.947 8.6235 198.081 9.17986C197.226 9.72551 196.466 10.4905 195.803 11.4748V19.8522C196.413 20.7724 197.087 21.4197 197.824 21.7941C198.573 22.1686 199.423 22.3558 200.375 22.3558C201.316 22.3558 202.14 22.1847 202.845 21.8423C203.551 21.4999 204.139 21.0184 204.61 20.3979C205.091 19.7666 205.449 19.0177 205.685 18.1511C205.931 17.2738 206.054 16.3108 206.054 15.2623C206.054 12.8871 205.615 11.1431 204.738 10.0304C203.872 8.90703 202.615 8.34533 200.969 8.34533ZM213.422 0V23.3509H211.898V0H213.422ZM229.248 23.3509C228.928 23.3509 228.73 23.2011 228.655 22.9015L228.43 20.8633C227.992 21.2913 227.553 21.6764 227.115 22.0188C226.687 22.3612 226.238 22.6501 225.767 22.8854C225.297 23.1208 224.789 23.2974 224.243 23.4151C223.698 23.5434 223.099 23.6076 222.447 23.6076C221.902 23.6076 221.372 23.5274 220.859 23.3669C220.345 23.2064 219.891 22.9603 219.495 22.6287C219.1 22.297 218.779 21.8744 218.533 21.3608C218.298 20.8366 218.18 20.2107 218.18 19.4831C218.18 18.8091 218.372 18.1832 218.757 17.6054C219.142 17.0277 219.741 16.5248 220.554 16.0968C221.377 15.6689 222.431 15.3265 223.714 15.0697C225.008 14.813 226.559 14.6632 228.366 14.6204V12.9513C228.366 11.4748 228.045 10.3407 227.404 9.54898C226.773 8.74654 225.832 8.34533 224.58 8.34533C223.81 8.34533 223.153 8.45232 222.607 8.6663C222.073 8.88028 221.618 9.11566 221.244 9.37244C220.87 9.62922 220.565 9.8646 220.329 10.0786C220.094 10.2926 219.896 10.3996 219.736 10.3996C219.522 10.3996 219.362 10.3033 219.255 10.1107L218.982 9.64527C219.816 8.81074 220.693 8.17949 221.613 7.75152C222.532 7.32356 223.575 7.10958 224.741 7.10958C225.596 7.10958 226.345 7.24866 226.987 7.52684C227.628 7.79432 228.158 8.18484 228.575 8.6984C229.002 9.20126 229.323 9.81646 229.537 10.544C229.751 11.2608 229.858 12.0633 229.858 12.9513V23.3509H229.248ZM222.832 22.5003C223.452 22.5003 224.019 22.4361 224.532 22.3077C225.056 22.1686 225.537 21.9814 225.976 21.746C226.425 21.4999 226.842 21.211 227.227 20.8794C227.612 20.5477 227.992 20.1893 228.366 19.8041V15.6475C226.848 15.6903 225.537 15.808 224.436 16.0006C223.345 16.1824 222.442 16.4339 221.725 16.7548C221.019 17.0758 220.495 17.461 220.153 17.9104C219.821 18.349 219.656 18.8519 219.656 19.4189C219.656 19.9539 219.741 20.4193 219.912 20.8152C220.094 21.2003 220.329 21.5213 220.618 21.7781C220.907 22.0242 221.244 22.2061 221.629 22.3237C222.014 22.4414 222.415 22.5003 222.832 22.5003ZM239.028 23.6076C237.948 23.6076 237.103 23.3081 236.494 22.7089C235.895 22.1098 235.596 21.1843 235.596 19.9325V9.01937H233.302C233.184 9.01937 233.088 8.98727 233.013 8.92308C232.938 8.85888 232.901 8.76794 232.901 8.65025V8.05645L235.628 7.86386L236.013 2.15053C236.023 2.05424 236.061 1.96864 236.125 1.89375C236.2 1.81885 236.296 1.78141 236.414 1.78141H237.136V7.87991H242.157V9.01937H237.136V19.8522C237.136 20.2909 237.189 20.6707 237.296 20.9917C237.414 21.302 237.569 21.5588 237.761 21.762C237.964 21.9653 238.2 22.1151 238.467 22.2114C238.734 22.3077 239.023 22.3558 239.333 22.3558C239.718 22.3558 240.05 22.3023 240.328 22.1954C240.606 22.0777 240.846 21.9546 241.05 21.8262C241.253 21.6871 241.419 21.5641 241.547 21.4571C241.675 21.3394 241.777 21.2806 241.852 21.2806C241.937 21.2806 242.023 21.3341 242.108 21.4411L242.525 22.1151C242.119 22.5645 241.6 22.9282 240.969 23.2064C240.349 23.4739 239.702 23.6076 239.028 23.6076ZM252.117 7.12562C253.015 7.12562 253.844 7.28076 254.603 7.59104C255.373 7.90131 256.036 8.35603 256.592 8.95518C257.159 9.54363 257.597 10.2712 257.908 11.1378C258.228 12.0044 258.389 12.9994 258.389 14.1229C258.389 14.3582 258.351 14.5187 258.276 14.6043C258.212 14.6899 258.105 14.7327 257.956 14.7327H246.422V15.0376C246.422 16.2359 246.561 17.2898 246.839 18.1992C247.117 19.1087 247.513 19.8736 248.026 20.4942C248.539 21.104 249.16 21.5641 249.887 21.8744C250.614 22.1847 251.427 22.3398 252.325 22.3398C253.127 22.3398 253.822 22.2542 254.41 22.083C254.999 21.9011 255.491 21.7032 255.886 21.4892C256.293 21.2645 256.613 21.0666 256.849 20.8954C257.084 20.7135 257.255 20.6226 257.362 20.6226C257.501 20.6226 257.608 20.6761 257.683 20.7831L258.1 21.2966C257.843 21.6176 257.501 21.9172 257.073 22.1954C256.656 22.4735 256.186 22.7143 255.662 22.9175C255.148 23.1101 254.592 23.2653 253.993 23.383C253.405 23.5006 252.812 23.5595 252.213 23.5595C251.122 23.5595 250.127 23.3723 249.229 22.9978C248.331 22.6126 247.561 22.0563 246.919 21.3287C246.277 20.6012 245.78 19.7132 245.427 18.6646C245.085 17.6054 244.914 16.3964 244.914 15.0376C244.914 13.8928 245.074 12.839 245.395 11.876C245.727 10.9024 246.197 10.0679 246.807 9.37244C247.427 8.6663 248.181 8.11529 249.069 7.71943C249.967 7.32356 250.983 7.12562 252.117 7.12562ZM252.133 8.26508C251.309 8.26508 250.571 8.39347 249.919 8.65025C249.266 8.90703 248.7 9.27615 248.218 9.75761C247.748 10.2391 247.363 10.8168 247.063 11.4909C246.775 12.1649 246.582 12.9192 246.486 13.7537H257.009C257.009 12.8978 256.892 12.1328 256.656 11.4588C256.421 10.774 256.089 10.1963 255.662 9.72551C255.234 9.25475 254.721 8.89633 254.122 8.65025C253.523 8.39347 252.86 8.26508 252.133 8.26508ZM271.278 9.35639C271.203 9.50618 271.086 9.58108 270.925 9.58108C270.808 9.58108 270.653 9.51688 270.46 9.38849C270.278 9.2494 270.032 9.09962 269.722 8.93913C269.423 8.76794 269.048 8.61815 268.599 8.48976C268.161 8.35068 267.621 8.28113 266.979 8.28113C266.402 8.28113 265.872 8.36672 265.391 8.53791C264.92 8.6984 264.514 8.91773 264.172 9.19591C263.84 9.47408 263.578 9.80041 263.386 10.1749C263.204 10.5386 263.113 10.9238 263.113 11.3304C263.113 11.8332 263.241 12.2505 263.498 12.5822C263.755 12.9139 264.092 13.1974 264.509 13.4328C264.926 13.6681 265.396 13.8714 265.92 14.0426C266.455 14.2138 267 14.385 267.556 14.5562C268.113 14.7274 268.653 14.9199 269.177 15.1339C269.711 15.3372 270.187 15.594 270.604 15.9043C271.021 16.2145 271.358 16.5944 271.615 17.0437C271.872 17.4931 272 18.0387 272 18.6807C272 19.3761 271.872 20.0234 271.615 20.6226C271.369 21.2217 271.005 21.7406 270.524 22.1793C270.054 22.618 269.471 22.9657 268.776 23.2225C268.081 23.4793 267.289 23.6076 266.402 23.6076C265.279 23.6076 264.311 23.4311 263.498 23.078C262.685 22.7143 261.958 22.2435 261.316 21.6657L261.685 21.1201C261.739 21.0345 261.798 20.9703 261.862 20.9275C261.926 20.8847 262.017 20.8633 262.134 20.8633C262.273 20.8633 262.445 20.9489 262.648 21.1201C262.851 21.2913 263.113 21.4785 263.434 21.6818C263.765 21.8744 264.172 22.0563 264.653 22.2275C265.145 22.3986 265.749 22.4842 266.466 22.4842C267.139 22.4842 267.733 22.3933 268.246 22.2114C268.76 22.0188 269.187 21.762 269.53 21.4411C269.872 21.1201 270.128 20.7456 270.3 20.3177C270.481 19.879 270.572 19.4189 270.572 18.9375C270.572 18.4025 270.444 17.9585 270.187 17.6054C269.931 17.2524 269.594 16.9528 269.177 16.7067C268.76 16.4606 268.284 16.252 267.749 16.0808C267.225 15.9096 266.68 15.7384 266.113 15.5672C265.557 15.3961 265.011 15.2088 264.477 15.0055C263.952 14.8023 263.482 14.5455 263.065 14.2352C262.648 13.9249 262.311 13.5505 262.054 13.1118C261.798 12.6624 261.669 12.1061 261.669 11.4427C261.669 10.8757 261.792 10.33 262.038 9.80576C262.284 9.2815 262.632 8.82144 263.081 8.42557C263.541 8.0297 264.097 7.71408 264.749 7.4787C265.402 7.24332 266.134 7.12562 266.947 7.12562C267.92 7.12562 268.781 7.26471 269.53 7.54289C270.289 7.82107 270.984 8.24903 271.615 8.82679L271.278 9.35639Z" fill="var(--et_xstudio-white-color, #fff)"/>
            </svg>
        </span>
    <?php endif; ?>

    <div class="et_studio-dark-light-switcher">
        <span class="switcher <?php echo get_option('et_studio_dark_light_default', 'dark'); ?>-mode">
            <span class="on">Light</span>
            <span class="off">Dark</span>
            <i>
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 35 35" style="enable-background:new 0 0 35 35;" xml:space="preserve" class="light" width="1em" height="1em" fill="currentColor">
                  <g id="Sun">
                      <g>
                          <path style="fill-rule:evenodd;clip-rule:evenodd;" d="M6,17.5C6,16.672,5.328,16,4.5,16h-3C0.672,16,0,16.672,0,17.5    S0.672,19,1.5,19h3C5.328,19,6,18.328,6,17.5z M7.5,26c-0.414,0-0.789,0.168-1.061,0.439l-2,2C4.168,28.711,4,29.086,4,29.5    C4,30.328,4.671,31,5.5,31c0.414,0,0.789-0.168,1.06-0.44l2-2C8.832,28.289,9,27.914,9,27.5C9,26.672,8.329,26,7.5,26z M17.5,6    C18.329,6,19,5.328,19,4.5v-3C19,0.672,18.329,0,17.5,0S16,0.672,16,1.5v3C16,5.328,16.671,6,17.5,6z M27.5,9    c0.414,0,0.789-0.168,1.06-0.439l2-2C30.832,6.289,31,5.914,31,5.5C31,4.672,30.329,4,29.5,4c-0.414,0-0.789,0.168-1.061,0.44    l-2,2C26.168,6.711,26,7.086,26,7.5C26,8.328,26.671,9,27.5,9z M6.439,8.561C6.711,8.832,7.086,9,7.5,9C8.328,9,9,8.328,9,7.5    c0-0.414-0.168-0.789-0.439-1.061l-2-2C6.289,4.168,5.914,4,5.5,4C4.672,4,4,4.672,4,5.5c0,0.414,0.168,0.789,0.439,1.06    L6.439,8.561z M33.5,16h-3c-0.828,0-1.5,0.672-1.5,1.5s0.672,1.5,1.5,1.5h3c0.828,0,1.5-0.672,1.5-1.5S34.328,16,33.5,16z     M28.561,26.439C28.289,26.168,27.914,26,27.5,26c-0.828,0-1.5,0.672-1.5,1.5c0,0.414,0.168,0.789,0.439,1.06l2,2    C28.711,30.832,29.086,31,29.5,31c0.828,0,1.5-0.672,1.5-1.5c0-0.414-0.168-0.789-0.439-1.061L28.561,26.439z M17.5,29    c-0.829,0-1.5,0.672-1.5,1.5v3c0,0.828,0.671,1.5,1.5,1.5s1.5-0.672,1.5-1.5v-3C19,29.672,18.329,29,17.5,29z M17.5,7    C11.71,7,7,11.71,7,17.5S11.71,28,17.5,28S28,23.29,28,17.5S23.29,7,17.5,7z M17.5,25c-4.136,0-7.5-3.364-7.5-7.5    c0-4.136,3.364-7.5,7.5-7.5c4.136,0,7.5,3.364,7.5,7.5C25,21.636,21.636,25,17.5,25z"></path>
                      </g>
                  </g>
                </svg>
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 100 100" xml:space="preserve" class="dark" width="1em" height="1em" fill="currentColor">
                  <path d="M96.76,66.458c-0.853-0.852-2.15-1.064-3.23-0.534c-6.063,2.991-12.858,4.571-19.655,4.571  C62.022,70.495,50.88,65.88,42.5,57.5C29.043,44.043,25.658,23.536,34.076,6.47c0.532-1.08,0.318-2.379-0.534-3.23  c-0.851-0.852-2.15-1.064-3.23-0.534c-4.918,2.427-9.375,5.619-13.246,9.491c-9.447,9.447-14.65,22.008-14.65,35.369  c0,13.36,5.203,25.921,14.65,35.368s22.008,14.65,35.368,14.65c13.361,0,25.921-5.203,35.369-14.65  c3.872-3.871,7.064-8.328,9.491-13.246C97.826,68.608,97.611,67.309,96.76,66.458z"></path>
                </svg>
            </i>
        </span>
    </div>

</script>

<script type="text/template" id="tmpl-et-studio-menu">
    <ul class="main-studio-menu">
        <li><a href="<?php echo wp_customize_url(); ?>"><?php echo esc_html__('Theme options', 'xstore-core'); ?></a></li>
        <li><a href="<?php etheme_documentation_url(); ?>" target="_blank"><?php echo esc_html__('Documentation', 'xstore-core' ); ?></a></li>
        <li><a href="<?php etheme_support_forum_url(true); ?>" target="_blank"><?php echo esc_html__('Support', 'xstore-core' ); ?></a></li>
    </ul>
    <ul class="templates-studio-menu">
        <li><a href="<?php echo apply_filters('etheme_support_forum_url', 'https://www.youtube.com/watch?v=i7STFGZapx8&list=PLMqMSqDgPNmCCyem_z9l2ZJ1owQUaFCE3&index=1'); ?>" target="_blank"><?php echo esc_html__('Video Tutorials', 'xstore-core'); ?></a></li>
        <li><a href="<?php etheme_documentation_url(); ?>" target="_blank"><?php echo esc_html__('Documentation', 'xstore-core' ); ?></a></li>
        <li><a href="<?php etheme_support_forum_url(true); ?>" target="_blank"><?php echo esc_html__('Support', 'xstore-core' ); ?></a></li>
    </ul>
</script>


<script type="text/html" id="tmpl-et_studio-dark-light-switcher">
     <div class="et_studio-dark-light-switcher hidden">
        <span class="switcher <?php echo get_option('et_studio_dark_light_default', 'dark'); ?>-mode">
            <span class="on">Light</span>
            <span class="off">Dark</span>
            <i>
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 35 35" style="enable-background:new 0 0 35 35;" xml:space="preserve" class="light" width="1em" height="1em" fill="currentColor">
                  <g id="Sun">
                      <g>
                          <path style="fill-rule:evenodd;clip-rule:evenodd;" d="M6,17.5C6,16.672,5.328,16,4.5,16h-3C0.672,16,0,16.672,0,17.5    S0.672,19,1.5,19h3C5.328,19,6,18.328,6,17.5z M7.5,26c-0.414,0-0.789,0.168-1.061,0.439l-2,2C4.168,28.711,4,29.086,4,29.5    C4,30.328,4.671,31,5.5,31c0.414,0,0.789-0.168,1.06-0.44l2-2C8.832,28.289,9,27.914,9,27.5C9,26.672,8.329,26,7.5,26z M17.5,6    C18.329,6,19,5.328,19,4.5v-3C19,0.672,18.329,0,17.5,0S16,0.672,16,1.5v3C16,5.328,16.671,6,17.5,6z M27.5,9    c0.414,0,0.789-0.168,1.06-0.439l2-2C30.832,6.289,31,5.914,31,5.5C31,4.672,30.329,4,29.5,4c-0.414,0-0.789,0.168-1.061,0.44    l-2,2C26.168,6.711,26,7.086,26,7.5C26,8.328,26.671,9,27.5,9z M6.439,8.561C6.711,8.832,7.086,9,7.5,9C8.328,9,9,8.328,9,7.5    c0-0.414-0.168-0.789-0.439-1.061l-2-2C6.289,4.168,5.914,4,5.5,4C4.672,4,4,4.672,4,5.5c0,0.414,0.168,0.789,0.439,1.06    L6.439,8.561z M33.5,16h-3c-0.828,0-1.5,0.672-1.5,1.5s0.672,1.5,1.5,1.5h3c0.828,0,1.5-0.672,1.5-1.5S34.328,16,33.5,16z     M28.561,26.439C28.289,26.168,27.914,26,27.5,26c-0.828,0-1.5,0.672-1.5,1.5c0,0.414,0.168,0.789,0.439,1.06l2,2    C28.711,30.832,29.086,31,29.5,31c0.828,0,1.5-0.672,1.5-1.5c0-0.414-0.168-0.789-0.439-1.061L28.561,26.439z M17.5,29    c-0.829,0-1.5,0.672-1.5,1.5v3c0,0.828,0.671,1.5,1.5,1.5s1.5-0.672,1.5-1.5v-3C19,29.672,18.329,29,17.5,29z M17.5,7    C11.71,7,7,11.71,7,17.5S11.71,28,17.5,28S28,23.29,28,17.5S23.29,7,17.5,7z M17.5,25c-4.136,0-7.5-3.364-7.5-7.5    c0-4.136,3.364-7.5,7.5-7.5c4.136,0,7.5,3.364,7.5,7.5C25,21.636,21.636,25,17.5,25z"></path>
                      </g>
                  </g>
                </svg>
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 100 100" xml:space="preserve" class="dark" width="1em" height="1em" fill="currentColor">
                  <path d="M96.76,66.458c-0.853-0.852-2.15-1.064-3.23-0.534c-6.063,2.991-12.858,4.571-19.655,4.571  C62.022,70.495,50.88,65.88,42.5,57.5C29.043,44.043,25.658,23.536,34.076,6.47c0.532-1.08,0.318-2.379-0.534-3.23  c-0.851-0.852-2.15-1.064-3.23-0.534c-4.918,2.427-9.375,5.619-13.246,9.491c-9.447,9.447-14.65,22.008-14.65,35.369  c0,13.36,5.203,25.921,14.65,35.368s22.008,14.65,35.368,14.65c13.361,0,25.921-5.203,35.369-14.65  c3.872-3.871,7.064-8.328,9.491-13.246C97.826,68.608,97.611,67.309,96.76,66.458z"></path>
                </svg>
            </i>
        </span>
    </div>
</script>
<script type="text/html" id="tmpl-et-studio-actions">
    <div id="et-studio-sync" class="elementor-templates-modal__header__item">
        <i class="eicon-sync" aria-hidden="true" title="<?php esc_attr_e( 'Sync Library', 'xstore-core' ); ?>" et-title="<?php esc_attr_e( 'Refresh', 'xstore-core' ); ?>"></i>
    </div>
    <div class="et-studio-filters">
        <ul>
            <li><span><svg version="1.1" width="1em" height="1em" class="et-icon" fill="currentColor" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100" style="enable-background:new 0 0 100 100;" xml:space="preserve">
                        <path d="M94.8,0H5.6C4,0,2.6,0.9,1.9,2.3C1.1,3.7,1.3,5.4,2.2,6.7l32.7,46c0,0,0,0,0,0c1.2,1.6,1.8,3.5,1.8,5.5v37.5c0,1.1,0.4,2.2,1.2,3c0.8,0.8,1.8,1.2,3,1.2c0.6,0,1.1-0.1,1.6-0.3l18.4-7c1.6-0.5,2.7-2.1,2.7-3.9V58.3c0-2,0.6-3.9,1.8-5.5c0,0,0,0,0,0l32.7-46c0.9-1.3,1.1-3,0.3-4.4C97.8,0.9,96.3,0,94.8,0z M61.4,49.7c-1.8,2.5-2.8,5.5-2.8,8.5v29.8l-16.8,6.4V58.3c0-3.1-1-6.1-2.8-8.5L7.3,5.1h85.8L61.4,49.7z"></path>
                            </svg><span>Filter</span></span>
                <ul>
                    <?php 
                        $data = get_option('et_studio_data_global-studio');
                        
                        if( is_array($data) && isset($data['filters'])){
                            foreach($data['filters'] as $k => $v){
                                $class = 'et_studio-filter';
                                if($k == 'all'){
                                    $class .= ' active';
                                }
                                echo '<li data-filter="'.esc_js($k).'" class="'.esc_js($class).'"><span>'.esc_js($v['title']).'</span><span class="count">'.esc_js($v['count']).'</span></li>';
                            }
                        } else {
                            echo '<li class="et_studio-filter-no-found" style="width:100%; text-transform:none;"><span>'.esc_html__("Filters could not load properly. Please refresh the page or try again later.", 'xstore-core').'</span></li>';
                        }
                    ?>
                </ul>
            </li>
        </ul>
    </div>

    <div class="et-studio-search">
        <input type="text" placeholder="<?php echo esc_attr('Type searching...', 'xstore-core' ); ?>">
        <i>
            <svg version="1.1" xmlns="http://www.w3.org/2000/svg" fill="currentColor" width="1em" height="1em" viewBox="0 0 24 24">
                <path d="M23.784 22.8l-6.168-6.144c1.584-1.848 2.448-4.176 2.448-6.576 0-5.52-4.488-10.032-10.032-10.032-5.52 0-10.008 4.488-10.008 10.008s4.488 10.032 10.032 10.032c2.424 0 4.728-0.864 6.576-2.472l6.168 6.144c0.144 0.144 0.312 0.216 0.48 0.216s0.336-0.072 0.456-0.192c0.144-0.12 0.216-0.288 0.24-0.48 0-0.192-0.072-0.384-0.192-0.504zM18.696 10.080c0 4.752-3.888 8.64-8.664 8.64-4.752 0-8.64-3.888-8.64-8.664 0-4.752 3.888-8.64 8.664-8.64s8.64 3.888 8.64 8.664z"></path>
            </svg>
        </i>
        <span class="spinner">
            <div class="et-loader ">
                <svg class="loader-circular" viewBox="25 25 50 50">
                    <circle class="loader-path" cx="50" cy="50" r="12" fill="none" stroke-width="2" stroke-miterlimit="10"></circle>
                </svg>
            </div>
        </span>
    </div>

</script>



<script type="text/template" id="tmpl-et-studio-back">
    <i class="eicon-" aria-hidden="true"></i>
    <span class="main-studio-back"><?php esc_html_e( 'Back to Library', 'xstore-core' ); ?></span>
    <span class="templates-studio-back"><?php esc_html_e( 'Back to Templates', 'xstore-core' ); ?></span>
</script>

<script type="text/template" id="tmpl-et-studio-menu-responsive">
    <ul>
        <li>
            <a href="#" data-device="desktop" class="active">
                <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" height="2em" viewBox="0 0 24 24" width="2em"><path d="M0 0h24v24H0z" fill="none"/><path d="M21 2H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h7l-2 3v1h8v-1l-2-3h7c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 12H3V4h18v10z"/></svg>
            </a>
        </li>
        <li>
            <a href="#" data-device="laptop">
                <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" height="2em" viewBox="0 0 24 24" width="2em"><path d="M0 0h24v24H0z" fill="none"/><path d="M20 18c1.1 0 1.99-.9 1.99-2L22 5c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v11c0 1.1.9 2 2 2H0c0 1.1.9 2 2 2h20c1.1 0 2-.9 2-2h-4zM4 5h16v11H4V5zm8 14c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z"/></svg>
            </a>
        </li>
        <li>
            <a href="#" data-device="mobile">
                <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" height="2em" viewBox="0 0 24 24" width="2em"><path d="M0 0h24v24H0z" fill="none"/><path d="M15.5 1h-8C6.12 1 5 2.12 5 3.5v17C5 21.88 6.12 23 7.5 23h8c1.38 0 2.5-1.12 2.5-2.5v-17C18 2.12 16.88 1 15.5 1zm-4 21c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm4.5-4H7V4h9v14z"/></svg>
            </a>
        </li>
    </ul>
</script>



<script type="text/template" id="tmpl-et-studio-preview">
    <iframe></iframe>
    <?php if (get_option('elementor_experiment-container') == 'inactive') : ?>
        <div class="et_popup-notice" data-notice="experiment-container">
            <span class="et_popup-notice-btn et_btn-close">X</span>
		    <?php $elementor_experiments_url = admin_url('admin.php?page=elementor-settings#tab-experiments'); ?>
		    <?php esc_html_e('An error occurred during the import of demo data. To address this issue and ensure a successful import, please activate the Flexbox Container option to "Active" in the Elementor settings. You can do this by following this link:','xstore-core');?>
            <a class="a-black" href="<?php echo esc_url($elementor_experiments_url); ?>" target="_blank"><?php echo esc_url($elementor_experiments_url); ?></a>
        </div>
    <?php endif;?>
</script>

<script type="text/template" id="tmpl-et-studio-header-insert">
    <div id="elementor-template-library-header-preview-insert-wrapper" class="elementor-templates-modal__header__item">
        {{{ et_studio.library.getModal().getTemplateActionButton( obj ) }}}
    </div>
</script>

<script type="text/template" id="tmpl-et-studio-insert-button">
    <a class="elementor-template-library-template-action elementor-button et-studio-insert-button">
        <i class="eicon-file-download" aria-hidden="true"></i>
        <span class="elementor-button-title"><?php esc_html_e( 'Insert', 'xstore-core' ); ?></span>
    </a>
</script>

<script type="text/template" id="tmpl-et-studio-loading">
    <div class="elementor-loader-wrapper">
        <div class="elementor-loader">
            <div class="elementor-loader-boxes">
                <div class="elementor-loader-box"></div>
                <div class="elementor-loader-box"></div>
                <div class="elementor-loader-box"></div>
                <div class="elementor-loader-box"></div>
            </div>
        </div>
        <div class="elementor-loading-title"><?php esc_html_e( 'Loading', 'xstore-core' ); ?></div>
    </div>
</script>

<script type="text/template" id="tmpl-et-studio-templates">
    <div class="et-studio-templates-window">
        <!-- <div class="et-studio-loader">
            <span class="et-studio-loaded-images" data-size="0">0</span>
        </div> -->
        <?php if (get_option('elementor_experiment-container') == 'inactive') : ?>
            <div class="et_popup-notice" data-notice="experiment-container">
                <span class="et_popup-notice-btn et_btn-close">X</span>
                <?php $elementor_experiments_url = admin_url('admin.php?page=elementor-settings#tab-experiments'); ?>
                <?php esc_html_e('An error occurred during the import of demo data. To address this issue and ensure a successful import, please activate the Flexbox Container option to "Active" in the Elementor settings. You can do this by following this link:','xstore-core');?>
                <a class="a-black" href="<?php echo esc_url($elementor_experiments_url); ?>" target="_blank"><?php echo esc_url($elementor_experiments_url); ?></a>
            </div>
        <?php endif;?>
        <div class="et-studio-empty-search hidden">
            <img src="<?php echo ET_CORE_URL . 'app/models/studio/img/empty-search.png'; ?>" alt="empty-search">
            <h2>Whoops...</h2>
            <p>We couldn't find "<strong class="et-studio-empty-search-request">your word</strong>" shop you were looking for.</p>
        </div>
        <div id="et-studio-templates-list" style="    display: inline-block;
    height: 100%;"></div>
    </div>
</script>

<script type="text/template"  id="tmpl-et-studio-template">
    <div class="et-studio-template-body elementor-template-library-template-body" data-tags="{{{tags}}}" data-cats="{{{cats}}}" id="et-template-{{ template_id }}">
        <img src="<?php echo ETHEME_BASE_URI . ETHEME_CODE . 'assets/images/placeholder-350x268.png'; ?>" class="lazyload lazyload-simple" data-src="{{{thumbnail}}}" alt="{{{template_id}}}">
        <div class=" et-template-preview elementor-template-library-template-preview">
            <i class="eicon-zoom-in-bold" aria-hidden="true"></i>
        </div>
    </div>
    <div class="et-studio-template-footer elementor-template-library-template-footer">
        <a href="#" class="elementor-button et-template-preview-button">
            <i class="eicon-device-desktop" aria-hidden="true"></i>
            <?php esc_html_e( 'Preview', 'xstore-core' ); ?>
        </a>
        {{{ et_studio.library.getModal().getTemplateActionButton( obj ) }}}
    </div>
</script>

<script type="text/template" id="tmpl-et-studio-empty">
    <div class="elementor-template-library-blank-icon">
        <img src="<?php echo ELEMENTOR_ASSETS_URL . 'images/no-search-results.svg'; ?>" class="elementor-template-library-no-results" />
    </div>
    <div class="elementor-template-library-blank-title"></div>
    <div class="elementor-template-library-blank-message"></div>
    <div class="elementor-template-library-blank-footer">
    </div>
</script>