<?php
/**
 * Plugin Name: Frete Grátis por Itens no Carrinho
 * Description: Ativa o frete grátis automaticamente quando o carrinho tem 3 ou mais itens. Remove o frete grátis quando tem menos.
 * Version: 1.0
 * Author: ChatGPT
 */

if (!defined('ABSPATH')) {
    exit; // Sai se acessado diretamente
}

add_filter('woocommerce_package_rates', 'fgpi_controlar_frete_gratis_por_quantidade', 100, 2);

function fgpi_controlar_frete_gratis_por_quantidade($rates, $package) {
    if (is_admin() && !defined('DOING_AJAX')) return $rates;

    $quantidade = WC()->cart->get_cart_contents_count();

    if ($quantidade < 3) {
        foreach ($rates as $rate_id => $rate) {
            if ($rate->method_id === 'free_shipping') {
                unset($rates[$rate_id]);
            }
        }
    }

    if ($quantidade >= 3) {
        foreach ($rates as $rate_id => $rate) {
            if ($rate->method_id !== 'free_shipping') {
                unset($rates[$rate_id]);
            }
        }
    }

    return $rates;
}
